/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.image.Channel;
import adams.data.image.transformer.AbstractBufferedImageTransformer;
import java.awt.image.BufferedImage;

public class SplitChannels
extends AbstractBufferedImageTransformer {
    private static final long serialVersionUID = 2959486760492196174L;
    protected Channel[] m_Channels;

    public String globalInfo() {
        return "Splits the image into the specified separate RGB channels. With the output channels all converted to grayscale.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("channel", "channels", (Object)new Channel[0]);
    }

    public void setChannels(Channel[] value) {
        this.m_Channels = value;
        this.reset();
    }

    public Channel[] getChannels() {
        return this.m_Channels;
    }

    public String channelsTipText() {
        return "The channels to get from the incoming image.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"channels", (Object)this.m_Channels);
    }

    protected void checkImage(BufferedImageContainer img) {
        super.checkImage((AbstractImageContainer)img);
        if (this.m_Channels.length == 0) {
            throw new IllegalStateException("No channel(s) selected!");
        }
    }

    protected BufferedImageContainer[] doTransform(BufferedImageContainer img) {
        int i;
        BufferedImageContainer[] result = new BufferedImageContainer[this.m_Channels.length];
        BufferedImage oldImg = BufferedImageHelper.convert((BufferedImage)((BufferedImage)img.getImage()), (int)2);
        for (i = 0; i < this.m_Channels.length; ++i) {
            BufferedImage newImg = new BufferedImage(img.getWidth(), img.getHeight(), 10);
            result[i] = (BufferedImageContainer)img.getHeader();
            result[i].setImage((Object)newImg);
        }
        for (int y = 0; y < oldImg.getHeight(); ++y) {
            for (int x = 0; x < oldImg.getWidth(); ++x) {
                int[] pixel = BufferedImageHelper.split((int)oldImg.getRGB(x, y));
                for (i = 0; i < this.m_Channels.length; ++i) {
                    int gray;
                    switch (this.m_Channels[i]) {
                        case RED: {
                            gray = pixel[0];
                            break;
                        }
                        case GREEN: {
                            gray = pixel[1];
                            break;
                        }
                        case BLUE: {
                            gray = pixel[2];
                            break;
                        }
                        case ALPHA: {
                            gray = pixel[3];
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unhandled channel: " + (Object)((Object)this.m_Channels[i]));
                        }
                    }
                    ((BufferedImage)result[i].getImage()).setRGB(x, y, BufferedImageHelper.combine((int)gray, (int)gray, (int)gray, (int)0));
                }
            }
        }
        return result;
    }
}

