/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.transformer;

import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.image.XScreenMaskHelper;
import adams.data.image.transformer.AbstractBufferedImageTransformer;
import adams.flow.control.StorageName;
import java.awt.image.BufferedImage;

public class SuppliedImageMask
extends AbstractBufferedImageTransformer {
    private static final long serialVersionUID = -922292531841315436L;
    protected StorageName m_Mask;
    protected boolean m_Down;
    protected int m_Threshold;
    protected int[][] m_MaskMatrix;

    public String globalInfo() {
        return "Masks out regions on the image using a supplied image from internal storage, making them transparent.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("mask", "mask", (Object)new StorageName());
        this.m_OptionManager.add("down", "down", (Object)true);
        this.m_OptionManager.add("threshold", "threshold", (Object)127, (Number)-1, (Number)255);
    }

    protected void reset() {
        super.reset();
        this.m_MaskMatrix = null;
    }

    public StorageName getMask() {
        return this.m_Mask;
    }

    public void setMask(StorageName value) {
        this.m_Mask = value;
        this.reset();
    }

    public String maskTipText() {
        return "The name of the storage name (image) to use as mask.";
    }

    public boolean getDown() {
        return this.m_Down;
    }

    public void setDown(boolean value) {
        this.m_Down = value;
        this.reset();
    }

    public String downTipText() {
        return "If true, then pixels <= threshold are not masked and the others' alpha channel are set to 0 (made transparent).";
    }

    public int getThreshold() {
        return this.m_Threshold;
    }

    public void setThreshold(int value) {
        if (value >= -1 && value <= 255) {
            this.m_Threshold = value;
            this.reset();
        } else {
            this.getLogger().severe("Threshold must be 0 >= value <= 255, or -1 for auto-thresholding, provided: " + value);
        }
    }

    public String thresholdTipText() {
        return "Threshold value used for binarization, specify -1 to automatically determine a threshold.";
    }

    protected void initMask() {
        int x;
        int y;
        BufferedImage maskImg;
        if (this.m_MaskMatrix != null) {
            return;
        }
        if (this.getFlowContext() == null) {
            throw new IllegalStateException("No flow context set!");
        }
        Object obj = this.getFlowContext().getStorageHandler().getStorage().get(this.m_Mask);
        if (obj == null) {
            throw new IllegalStateException("Mask not available from storage: " + this.m_Mask);
        }
        if (obj instanceof BufferedImage) {
            maskImg = (BufferedImage)obj;
        } else if (obj instanceof AbstractImageContainer) {
            maskImg = ((AbstractImageContainer)obj).toBufferedImage();
        } else {
            throw new IllegalStateException("Mask must be either a " + BufferedImage.class.getName() + " or derived from " + AbstractImageContainer.class.getName() + ", found: " + obj.getClass().getName());
        }
        float[][] mask = new float[maskImg.getHeight()][maskImg.getWidth()];
        float min = Float.POSITIVE_INFINITY;
        float max = Float.NEGATIVE_INFINITY;
        for (y = 0; y < maskImg.getHeight(); ++y) {
            for (x = 0; x < maskImg.getWidth(); ++x) {
                mask[y][x] = maskImg.getRGB(x, y);
                max = Math.max(max, mask[y][x]);
                min = Math.min(min, mask[y][x]);
            }
        }
        this.m_MaskMatrix = new int[maskImg.getHeight()][maskImg.getWidth()];
        float ratio = 255.0f / (max - min);
        for (y = 0; y < mask.length; ++y) {
            for (x = 0; x < mask[0].length; ++x) {
                this.m_MaskMatrix[y][x] = Math.round((mask[y][x] - min) * ratio);
            }
        }
        XScreenMaskHelper.binarizeMask(this.m_MaskMatrix, this.m_Threshold, this.m_Down, this.getLogger());
    }

    protected BufferedImageContainer[] doTransform(BufferedImageContainer container) {
        this.initMask();
        BufferedImage image = (BufferedImage)container.getImage();
        image = XScreenMaskHelper.applyMask(image, this.m_MaskMatrix, this.m_Threshold, this.m_Down, this.getLogger());
        container.setImage((Object)image);
        return new BufferedImageContainer[]{container};
    }
}

