/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.transformer;

import adams.data.image.BufferedImageContainer;
import adams.data.image.XScreenMaskHelper;
import adams.data.image.transformer.AbstractBufferedImageTransformer;
import java.awt.image.BufferedImage;

public class XScreenMask
extends AbstractBufferedImageTransformer {
    private static final long serialVersionUID = -922292531841315436L;
    protected XScreenMaskHelper.Color m_Color;
    protected boolean m_Down;
    protected int m_Threshold;

    public String globalInfo() {
        return "Masks out a color by making it transparent.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("color", "color", (Object)XScreenMaskHelper.Color.RED);
        this.m_OptionManager.add("down", "down", (Object)true);
        this.m_OptionManager.add("threshold", "threshold", (Object)127, (Number)-1, (Number)255);
    }

    public XScreenMaskHelper.Color getColor() {
        return this.m_Color;
    }

    public void setColor(XScreenMaskHelper.Color value) {
        if (value != null) {
            this.m_Color = value;
            this.reset();
        } else {
            this.getLogger().severe("Color must not be null.");
        }
    }

    public String colorTipText() {
        return "Color to be masked.";
    }

    public boolean getDown() {
        return this.m_Down;
    }

    public void setDown(boolean value) {
        this.m_Down = value;
        this.reset();
    }

    public String downTipText() {
        return "If true, then pixels <= threshold are not masked and the others' alpha channel are set to 0 (made transparent).";
    }

    public int getThreshold() {
        return this.m_Threshold;
    }

    public void setThreshold(int value) {
        if (value >= -1 && value <= 255) {
            this.m_Threshold = value;
            this.reset();
        } else {
            this.getLogger().severe("Threshold must be 0 >= value <= 255, or -1 for auto-thresholding, provided: " + value);
        }
    }

    public String thresholdTipText() {
        return "Threshold value used for binarization, specify -1 to automatically determine a threshold.";
    }

    protected BufferedImageContainer[] doTransform(BufferedImageContainer container) {
        BufferedImage image = (BufferedImage)container.getImage();
        int[][] mask = XScreenMaskHelper.generateMask(image, this.m_Color);
        image = XScreenMaskHelper.applyMask(image, mask, this.m_Threshold, this.m_Down, this.getLogger());
        container.setImage((Object)image);
        return new BufferedImageContainer[]{container};
    }
}

