/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.transformer.crop;

import adams.data.image.ImageAnchor;
import adams.data.image.ImageAnchorHelper;
import adams.data.image.transformer.crop.AbstractCropAlgorithm;
import java.awt.Point;
import java.awt.image.BufferedImage;

public class RelativeCrop
extends AbstractCropAlgorithm {
    private static final long serialVersionUID = 2959486760492196174L;
    protected double m_X;
    protected double m_Y;
    protected double m_Width;
    protected double m_Height;
    protected ImageAnchor m_Anchor;
    protected boolean m_UseAnchorAtPos;

    public String globalInfo() {
        return "Crops the image to specified width and height. Where the crop rectangle starts is defined by the X and Y position and the anchor.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("x", "X", (Object)0.0, (Number)0.0, null);
        this.m_OptionManager.add("y", "Y", (Object)0.0, (Number)0.0, null);
        this.m_OptionManager.add("width", "width", (Object)1.0, (Number)1.0E-5, null);
        this.m_OptionManager.add("height", "height", (Object)1.0, (Number)1.0E-5, null);
        this.m_OptionManager.add("anchor", "anchor", (Object)ImageAnchor.TOP_LEFT);
        this.m_OptionManager.add("use-anchor-at-pos", "useAnchorAtPos", (Object)false);
    }

    public void setX(double value) {
        if (value >= 0.0) {
            this.m_X = value;
            this.reset();
        } else {
            this.getLogger().severe("X has to be >=0, provided: " + value);
        }
    }

    public double getX() {
        return this.m_X;
    }

    public String XTipText() {
        return "The horizontal pixel position (0-1: percent; >1: pixels).";
    }

    public void setY(double value) {
        if (value >= 0.0) {
            this.m_Y = value;
            this.reset();
        } else {
            this.getLogger().severe("Y has to be >=0, provided: " + value);
        }
    }

    public double getY() {
        return this.m_Y;
    }

    public String YTipText() {
        return "The vertical pixel position (0-1: percent; >1: pixels).";
    }

    public void setWidth(double value) {
        if (value > 0.0) {
            this.m_Width = value;
            this.reset();
        } else {
            this.getLogger().severe("Width has to be >0, provided: " + value);
        }
    }

    public double getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The width of the crop rectangle (0-1: percent; >1: pixels).";
    }

    public void setHeight(double value) {
        if (value > 0.0) {
            this.m_Height = value;
            this.reset();
        } else {
            this.getLogger().severe("Height has to be >0, provided: " + value);
        }
    }

    public double getHeight() {
        return this.m_Height;
    }

    public String heightTipText() {
        return "The height of the crop rectangle (0-1: percent; >1: pixels).";
    }

    public void setAnchor(ImageAnchor value) {
        this.m_Anchor = value;
        this.reset();
    }

    public ImageAnchor getAnchor() {
        return this.m_Anchor;
    }

    public String anchorTipText() {
        return "Defines where to anchor the position on the crop rectangle.";
    }

    public void setUseAnchorAtPos(boolean value) {
        this.m_UseAnchorAtPos = value;
        this.reset();
    }

    public boolean getUseAnchorAtPos() {
        return this.m_UseAnchorAtPos;
    }

    public String useAnchorAtPosTipText() {
        return "If enabled, the anchor gets placed at the x/y positiion and the corners of the crop are calculated accordingly; eg '" + (Object)((Object)ImageAnchor.MIDDLE_CENTER) + "' then refers to the center of the crop rectangle, with the center located at x/y.";
    }

    @Override
    protected BufferedImage doCrop(BufferedImage img) {
        Point[] corners = ImageAnchorHelper.calculateCorners(img, this.m_Anchor, this.m_X, this.m_Y, this.m_Width, this.m_Height, this.m_UseAnchorAtPos);
        this.m_TopLeft = corners[0];
        this.m_BottomRight = corners[1];
        int leftOrig = (int)this.m_TopLeft.getX();
        int topOrig = (int)this.m_TopLeft.getY();
        int width = (int)(this.m_BottomRight.getX() - this.m_TopLeft.getX() + 1.0);
        int height = (int)(this.m_BottomRight.getY() - this.m_TopLeft.getY() + 1.0);
        if (this.isLoggingEnabled()) {
            this.getLogger().info("x=" + this.m_X + ", y=" + this.m_Y + ", width=" + this.m_Width + ", height=" + this.m_Height + ", anchor=" + (Object)((Object)this.m_Anchor));
            this.getLogger().info("  --> top-left=" + this.m_TopLeft + ", bottom-right=" + this.m_BottomRight);
        }
        int heightOrig = img.getHeight();
        int widthOrig = img.getWidth();
        BufferedImage result = new BufferedImage(width, height, 2);
        for (int y = 0; y < height; ++y) {
            int yOrig = topOrig + y;
            if (yOrig < 0 || yOrig >= heightOrig) continue;
            for (int x = 0; x < width; ++x) {
                int xOrig = leftOrig + x;
                if (xOrig < 0 || xOrig >= widthOrig) continue;
                result.setRGB(x, y, img.getRGB(xOrig, yOrig));
            }
        }
        return result;
    }
}

