/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.data.image.BufferedImageContainer;
import adams.data.io.input.AbstractImageReader;
import adams.data.io.output.AbstractImageWriter;
import adams.data.io.output.SanselanImageWriter;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.logging.Level;
import org.apache.sanselan.Sanselan;

public class SanselanImageReader
extends AbstractImageReader<BufferedImageContainer> {
    private static final long serialVersionUID = 5347100846354068540L;

    public String globalInfo() {
        return "Sanselan image reader for: " + Utils.flatten((Object[])this.getFormatExtensions(), (String)", ");
    }

    public String getFormatDescription() {
        return "Sanselan image reader";
    }

    public String[] getFormatExtensions() {
        return new String[]{"bmp", "gif", "ico", "pbm", "pgm", "png", "pnm", "ppm", "psd", "tif", "tiff"};
    }

    public AbstractImageWriter getCorrespondingWriter() {
        return new SanselanImageWriter();
    }

    protected BufferedImageContainer doRead(PlaceholderFile file) {
        BufferedImage image;
        BufferedImageContainer result = null;
        try {
            image = Sanselan.getBufferedImage((File)file.getAbsoluteFile());
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to load: " + file, (Throwable)e);
            image = null;
        }
        if (image != null) {
            result = new BufferedImageContainer();
            result.setImage((Object)image);
        }
        return result;
    }
}

