/*
 * Decompiled with CFR 0.152.
 */
package adams.data.jai.features;

import adams.core.EnumWithCustomDisplay;
import adams.core.option.AbstractOption;
import adams.data.featureconverter.HeaderDefinition;
import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.image.features.AbstractBufferedImageFeatureGenerator;
import adams.data.report.DataType;
import adams.data.statistics.StatUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;

public class Histogram
extends AbstractBufferedImageFeatureGenerator {
    private static final long serialVersionUID = -8349656592325229512L;
    protected HistogramType m_HistogramType;
    protected int m_NumBins;
    protected boolean m_GroupChannels;

    public String globalInfo() {
        return "Turns an image into a histogram.\nIn case of an 8-bit histogram, the image must already be converted to a gray image.\nThe number of bins per channel can be chosen as well (1-256).";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("histo-type", "histogramType", (Object)HistogramType.RGB);
        this.m_OptionManager.add("num-bins", "numBins", (Object)256, (Number)1, (Number)256);
        this.m_OptionManager.add("group-channels", "groupChannels", (Object)false);
    }

    public void setHistogramType(HistogramType value) {
        this.m_HistogramType = value;
        this.reset();
    }

    public HistogramType getHistogramType() {
        return this.m_HistogramType;
    }

    public String histogramTypeTipText() {
        return "The type of histogram to generate.";
    }

    public void setNumBins(int value) {
        if (value >= 1 && value <= 256) {
            this.m_NumBins = value;
            this.reset();
        } else {
            this.getLogger().warning("Number of bins must meet 1 <= x <= 256, provided: " + value);
        }
    }

    public int getNumBins() {
        return this.m_NumBins;
    }

    public String numBinsTipText() {
        return "The number of bins per channel (1-256).";
    }

    public void setGroupChannels(boolean value) {
        this.m_GroupChannels = value;
        this.reset();
    }

    public boolean getGroupChannels() {
        return this.m_GroupChannels;
    }

    public String groupChannelsTipText() {
        return "If enabled, grouping is by channel rather than by bin.";
    }

    protected String[] getChannelSuffixes() {
        switch (this.m_HistogramType) {
            case EIGHT_BIT: {
                return new String[]{"_"};
            }
            case RGB: {
                return new String[]{"_r_", "_g_", "_b_"};
            }
        }
        throw new IllegalStateException("Unhandled histogram type: " + (Object)((Object)this.m_HistogramType));
    }

    @Override
    public HeaderDefinition createHeader(BufferedImageContainer img) {
        HeaderDefinition result = new HeaderDefinition();
        int numAtts = this.m_NumBins;
        String[] channels = this.getChannelSuffixes();
        if (this.m_GroupChannels) {
            for (String channel : channels) {
                for (int i = 0; i < numAtts; ++i) {
                    result.add("histo" + channel + (i + 1), DataType.NUMERIC);
                }
            }
        } else {
            for (int i = 0; i < numAtts; ++i) {
                for (String channel : channels) {
                    result.add("histo" + channel + (i + 1), DataType.NUMERIC);
                }
            }
        }
        return result;
    }

    @Override
    public List<Object>[] generateRows(BufferedImageContainer img) {
        int i;
        double[] high;
        double[] low;
        int[] bins;
        double[] values;
        List[] result = null;
        BufferedImage image = BufferedImageHelper.convert((BufferedImage)((BufferedImage)img.getImage()), (int)5);
        switch (this.m_HistogramType) {
            case EIGHT_BIT: {
                values = new double[this.m_NumBins];
                bins = new int[]{this.m_NumBins};
                low = new double[]{0.0};
                high = new double[]{this.m_NumBins};
                break;
            }
            case RGB: {
                values = new double[this.m_NumBins * 3];
                bins = new int[]{this.m_NumBins, this.m_NumBins, this.m_NumBins};
                low = new double[]{0.0, 0.0, 0.0};
                high = new double[]{this.m_NumBins, this.m_NumBins, this.m_NumBins};
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled histogram type: " + (Object)((Object)this.m_HistogramType));
            }
        }
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(PlanarImage.wrapRenderedImage((RenderedImage)image));
        pb.add(null);
        pb.add(1);
        pb.add(1);
        pb.add(bins);
        pb.add(low);
        pb.add(high);
        RenderedOp dst = JAI.create((String)"histogram", (ParameterBlock)pb, null);
        javax.media.jai.Histogram hist = (javax.media.jai.Histogram)dst.getProperty("histogram");
        switch (this.m_HistogramType) {
            case EIGHT_BIT: {
                for (i = 0; i < this.m_NumBins; ++i) {
                    values[i] = hist.getBinSize(0, i);
                }
                break;
            }
            case RGB: {
                for (i = 0; i < this.m_NumBins; ++i) {
                    values[i * 3 + 0] = hist.getBinSize(0, i);
                    if (hist.getNumBands() <= 1) continue;
                    values[i * 3 + 1] = hist.getBinSize(1, i);
                    values[i * 3 + 2] = hist.getBinSize(2, i);
                }
                break;
            }
        }
        String[] channels = this.getChannelSuffixes();
        result = new List[]{new ArrayList()};
        if (this.m_GroupChannels) {
            for (int n = 0; n < channels.length; ++n) {
                for (i = 0; i < this.m_NumBins; ++i) {
                    result[0].add(values[i * channels.length + n]);
                }
            }
        } else {
            result[0].addAll(Arrays.asList(StatUtils.toNumberArray((double[])values)));
        }
        return result;
    }

    public static enum HistogramType implements EnumWithCustomDisplay<HistogramType>
    {
        EIGHT_BIT("8-bit"),
        RGB("RGB");

        private String m_Display;
        private String m_Raw;

        private HistogramType(String display) {
            this.m_Display = display;
            this.m_Raw = super.toString();
        }

        public String toDisplay() {
            return this.m_Display;
        }

        public String toRaw() {
            return this.m_Raw;
        }

        public String toString() {
            return this.toDisplay();
        }

        public HistogramType parse(String s) {
            return HistogramType.valueOf((AbstractOption)null, s);
        }

        public static String toString(AbstractOption option, Object object) {
            return ((HistogramType)((Object)object)).toRaw();
        }

        public static HistogramType valueOf(AbstractOption option, String str) {
            HistogramType result = null;
            try {
                result = HistogramType.valueOf(str);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                for (HistogramType dt : HistogramType.values()) {
                    if (!dt.toDisplay().equals(str)) continue;
                    result = dt;
                    break;
                }
            }
            return result;
        }
    }
}

