/*
 * Decompiled with CFR 0.152.
 */
package adams.data.lire.features;

import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.data.featureconverter.HeaderDefinition;
import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.image.features.AbstractBufferedImageFeatureGenerator;
import adams.data.lire.features.Citation;
import adams.data.report.DataType;
import adams.data.statistics.StatUtils;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SpatialPyramidCentrist
extends AbstractBufferedImageFeatureGenerator
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -218939305183964139L;

    public String globalInfo() {
        return "Generates features using " + net.semanticmetadata.lire.imageanalysis.features.global.centrist.SpatialPyramidCentrist.class.getName() + ".\nFor more information, see:\n" + this.getTechnicalInformation().toString() + "\nFor more information on the LIRE project, see:\nhttp://www.lire-project.net/";
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Jianxin Wu; Rehg, J.M.");
        result.setValue(TechnicalInformation.Field.TITLE, "CENTRIST: A Visual Descriptor for Scene Categorization");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Pattern Analysis and Machine Intelligence");
        result.setValue(TechnicalInformation.Field.YEAR, "2011");
        result.setValue(TechnicalInformation.Field.PAGES, "1489-1501");
        result.setValue(TechnicalInformation.Field.HTTP, "http://ieeexplore.ieee.org/stamp/stamp.jsp?tp=&arnumber=5674051&isnumber=5898466/");
        result.add(Citation.getTechnicalInformation());
        return result;
    }

    @Override
    public HeaderDefinition createHeader(BufferedImageContainer img) {
        BufferedImage image = BufferedImageHelper.convert((BufferedImage)((BufferedImage)img.getImage()), (int)5);
        net.semanticmetadata.lire.imageanalysis.features.global.centrist.SpatialPyramidCentrist features = new net.semanticmetadata.lire.imageanalysis.features.global.centrist.SpatialPyramidCentrist();
        features.extract(image);
        double[] histo = features.getFeatureVector();
        HeaderDefinition result = new HeaderDefinition();
        for (int i = 0; i < histo.length; ++i) {
            result.add("SPCentrist-" + (i + 1), DataType.NUMERIC);
        }
        return result;
    }

    @Override
    public List<Object>[] generateRows(BufferedImageContainer img) {
        BufferedImage image = BufferedImageHelper.convert((BufferedImage)((BufferedImage)img.getImage()), (int)5);
        net.semanticmetadata.lire.imageanalysis.features.global.centrist.SpatialPyramidCentrist features = new net.semanticmetadata.lire.imageanalysis.features.global.centrist.SpatialPyramidCentrist();
        features.extract(image);
        double[] histo = features.getFeatureVector();
        List[] result = new List[]{new ArrayList()};
        result[0].addAll(Arrays.asList(StatUtils.toNumberArray((double[])histo)));
        return result;
    }
}

