/*
 * Decompiled with CFR 0.152.
 */
package adams.data.objectfinder;

import adams.core.QuickInfoHelper;
import adams.core.QuickInfoSupporter;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.OptionHandler;
import adams.data.objectfinder.ObjectFinder;
import adams.data.report.Report;
import adams.flow.transformer.locateobjects.LocatedObjects;

public abstract class AbstractObjectFinder
extends AbstractOptionHandler
implements ObjectFinder,
QuickInfoSupporter {
    private static final long serialVersionUID = 2092237222859238898L;
    protected String m_Prefix;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("prefix", "prefix", (Object)"Object.");
    }

    @Override
    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    @Override
    public String getPrefix() {
        return this.m_Prefix;
    }

    @Override
    public String prefixTipText() {
        return "The report field prefix used in the report.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"prefix", (Object)this.m_Prefix, (String)"prefix: ");
    }

    protected String check(LocatedObjects objects) {
        return null;
    }

    protected abstract int[] doFind(LocatedObjects var1);

    @Override
    public int[] find(LocatedObjects objects) {
        String msg = this.check(objects);
        if (msg != null) {
            throw new IllegalStateException(msg);
        }
        return this.doFind(objects);
    }

    @Override
    public int[] find(Report report) {
        if (report == null) {
            throw new IllegalStateException("No report provided!");
        }
        return this.find(LocatedObjects.fromReport(report, this.m_Prefix));
    }

    @Override
    public LocatedObjects findObjects(LocatedObjects objects) {
        int[] indices = this.find(objects);
        return objects.subset(indices);
    }

    @Override
    public LocatedObjects findObjects(Report report) {
        return this.findObjects(LocatedObjects.fromReport(report, this.m_Prefix));
    }
}

