/*
 * Decompiled with CFR 0.152.
 */
package adams.data.objectfinder;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseRegExp;
import adams.core.option.OptionHandler;
import adams.data.objectfinder.AbstractObjectFinder;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import gnu.trove.list.array.TIntArrayList;

public class ByMetaDataStringValue
extends AbstractObjectFinder {
    private static final long serialVersionUID = 4793599743931691992L;
    protected String m_Key;
    protected BaseRegExp m_RegExp;

    public String globalInfo() {
        return "Outputs the indices of objects where the specified regular expression matches the value associated with the given meta-data key.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("key", "key", (Object)"");
        this.m_OptionManager.add("regexp", "regExp", (Object)new BaseRegExp(".*"));
    }

    public void setKey(String value) {
        this.m_Key = value;
        this.reset();
    }

    public String getKey() {
        return this.m_Key;
    }

    public String keyTipText() {
        return "The meta-data key to check.";
    }

    public void setRegExp(BaseRegExp value) {
        this.m_RegExp = value;
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_RegExp;
    }

    public String regExpTipText() {
        return "The regular expression that the meta-data value must match.";
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"key", (Object)this.m_Key, (String)", key: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"regExp", (BaseRegExp)this.m_RegExp, (String)", regexp: ");
        return result;
    }

    @Override
    protected int[] doFind(LocatedObjects objects) {
        TIntArrayList result = new TIntArrayList();
        for (LocatedObject obj : objects) {
            if (obj.getMetaData() == null || !obj.getMetaData().containsKey(this.m_Key) || !this.m_RegExp.isMatch("" + obj.getMetaData().get(this.m_Key))) continue;
            result.add(obj.getIndex());
        }
        return result.toArray();
    }
}

