/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.conversion.BufferedImageToBufferedImage;
import adams.data.conversion.BufferedImageToOtherFormatConversion;
import adams.data.image.BufferedImageContainer;
import adams.flow.core.Token;
import adams.flow.source.AbstractSimpleSource;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class NewImage
extends AbstractSimpleSource {
    private static final long serialVersionUID = -5718059337341470131L;
    protected int m_Width;
    protected int m_Height;
    protected Color m_Background;
    protected boolean m_AlphaChannel;
    protected BufferedImageToOtherFormatConversion m_Conversion;

    public String globalInfo() {
        return "Generates an empty image with the specified dimensions (Type: RGB or ARBG).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("width", "width", (Object)this.getDefaultWidth(), (Number)1, null);
        this.m_OptionManager.add("height", "height", (Object)this.getDefaultHeight(), (Number)1, null);
        this.m_OptionManager.add("alpha-channel", "alphaChannel", (Object)false);
        this.m_OptionManager.add("background", "background", (Object)this.getDefaultBackground());
        this.m_OptionManager.add("conversion", "conversion", (Object)new BufferedImageToBufferedImage());
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"width", (Object)this.m_Width);
        result = result + " x ";
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"height", (Object)this.m_Height);
        String value = QuickInfoHelper.toString((OptionHandler)this, (String)"alphaChannel", (boolean)this.m_AlphaChannel, (String)"alpha", (String)", ");
        if (value != null) {
            result = result + value;
        }
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"background", (Object)this.m_Background, (String)", background: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"conversion", (Object)this.m_Conversion, (String)", conversion: ");
        return result;
    }

    public int getDefaultWidth() {
        return 800;
    }

    public void setWidth(int value) {
        this.m_Width = value;
        this.reset();
    }

    public int getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The width of the image.";
    }

    public int getDefaultHeight() {
        return 600;
    }

    public void setHeight(int value) {
        this.m_Height = value;
        this.reset();
    }

    public int getHeight() {
        return this.m_Height;
    }

    public String heightTipText() {
        return "The height of the image.";
    }

    public void setAlphaChannel(boolean value) {
        this.m_AlphaChannel = value;
        this.reset();
    }

    public boolean getAlphaChannel() {
        return this.m_AlphaChannel;
    }

    public String alphaChannelTipText() {
        return "If enabled, the alpha channel gets added as well (type is then ARGB instead of RGB).";
    }

    public Color getDefaultBackground() {
        return Color.WHITE;
    }

    public void setBackground(Color value) {
        this.m_Background = value;
        this.reset();
    }

    public Color getBackground() {
        return this.m_Background;
    }

    public String backgroundTipText() {
        return "The background color of the image.";
    }

    public void setConversion(BufferedImageToOtherFormatConversion value) {
        this.m_Conversion = value;
        this.reset();
    }

    public BufferedImageToOtherFormatConversion getConversion() {
        return this.m_Conversion;
    }

    public String conversionTipText() {
        return "The conversion for turning the " + BufferedImageContainer.class.getName() + " into another format if necessary.";
    }

    public Class[] generates() {
        return new Class[]{this.m_Conversion.generates()};
    }

    protected String doExecute() {
        String result = null;
        BufferedImage image = this.m_AlphaChannel ? new BufferedImage(this.m_Width, this.m_Height, 2) : new BufferedImage(this.m_Width, this.m_Height, 1);
        Graphics2D g = image.createGraphics();
        g.setColor(this.m_Background);
        g.fillRect(0, 0, this.m_Width, this.m_Height);
        g.dispose();
        BufferedImageContainer cont = new BufferedImageContainer();
        cont.setImage((Object)image);
        if (!(this.m_Conversion instanceof BufferedImageToBufferedImage)) {
            this.m_Conversion.setInput(cont);
            result = this.m_Conversion.convert();
            if (result == null) {
                this.m_OutputToken = new Token(this.m_Conversion.getOutput());
            }
            this.m_Conversion.cleanUp();
        } else {
            this.m_OutputToken = new Token((Object)cont);
        }
        return result;
    }
}

