/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseRegExp;
import adams.core.option.OptionHandler;
import adams.data.report.Report;
import adams.data.spreadsheet.DefaultSpreadSheet;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;

public class CompareObjectTypes
extends AbstractTransformer {
    private static final long serialVersionUID = -2856574104135118360L;
    protected String m_Prefix;
    protected String m_TypeSuffix;
    protected BaseRegExp m_TypeFind;
    protected String m_TypeReplace;
    protected double m_MinOverlapRatio;

    public String globalInfo() {
        return "Compares the object types between objects from the two reports.\nThe first report is considered 'ground truth'.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("prefix", "prefix", (Object)"Object.");
        this.m_OptionManager.add("type-suffix", "typeSuffix", (Object)"");
        this.m_OptionManager.add("type-find", "typeFind", (Object)new BaseRegExp(""));
        this.m_OptionManager.add("type-replace", "typeReplace", (Object)"");
        this.m_OptionManager.add("min-overlap-ratio", "minOverlapRatio", (Object)0.0, (Number)0.0, (Number)1.0);
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The report field prefix used in the report.";
    }

    public void setTypeSuffix(String value) {
        this.m_TypeSuffix = value;
        this.reset();
    }

    public String getTypeSuffix() {
        return this.m_TypeSuffix;
    }

    public String typeSuffixTipText() {
        return "The report field suffix for the type used in the report (ignored if empty).";
    }

    public void setTypeFind(BaseRegExp value) {
        this.m_TypeFind = value;
        this.reset();
    }

    public BaseRegExp getTypeFind() {
        return this.m_TypeFind;
    }

    public String typeFindTipText() {
        return "The regular expression to apply to the type, ignored if empty.";
    }

    public void setTypeReplace(String value) {
        this.m_TypeReplace = value;
        this.reset();
    }

    public String getTypeReplace() {
        return this.m_TypeReplace;
    }

    public String typeReplaceTipText() {
        return "The replacement string to use with the replacement regular expression.";
    }

    public void setMinOverlapRatio(double value) {
        if (this.getOptionManager().isValid("minOverlapRatio", (Number)value)) {
            this.m_MinOverlapRatio = value;
            this.reset();
        }
    }

    public double getMinOverlapRatio() {
        return this.m_MinOverlapRatio;
    }

    public String minOverlapRatioTipText() {
        return "The minimum ratio that an overlap must have before being considered an actual overlap.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"prefix", (Object)this.m_Prefix, (String)"prefix: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"typeSuffix", (Object)(this.m_TypeSuffix.isEmpty() ? "-ignored-" : this.m_TypeSuffix), (String)", type suffix: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"minOverlapRatio", (Object)this.m_MinOverlapRatio, (String)", overlap ratio: ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Report[].class};
    }

    public Class[] generates() {
        return new Class[]{SpreadSheet.class};
    }

    protected void updateType(LocatedObject obj, String typeKey) {
        if (!typeKey.isEmpty() && !this.m_TypeFind.isEmpty() && obj.getMetaData().containsKey(typeKey)) {
            String typeNew = obj.getMetaData().get(typeKey).toString();
            typeNew = typeNew.replaceFirst(this.m_TypeFind.getValue(), this.m_TypeReplace);
            obj.getMetaData().put(typeKey, typeNew);
        }
    }

    protected String doExecute() {
        String result = null;
        DefaultSpreadSheet sheet = null;
        Report truth = null;
        Report other = null;
        Report[] reports = (Report[])this.m_InputToken.getPayload();
        if (reports.length == 2) {
            truth = reports[0];
            other = reports[1];
        } else {
            result = "Expected two reports, found: " + reports.length;
        }
        if (result == null) {
            LocatedObjects truthObjs = LocatedObjects.fromReport(truth, this.m_Prefix);
            LocatedObjects otherObjs = LocatedObjects.fromReport(other, this.m_Prefix);
            String suffix = this.m_TypeSuffix.startsWith(".") ? this.m_TypeSuffix.substring(1) : this.m_TypeSuffix;
            String typeKey = this.m_TypeSuffix.startsWith(".") ? this.m_TypeSuffix.substring(1) : this.m_TypeSuffix;
            sheet = new DefaultSpreadSheet();
            HeaderRow row = sheet.getHeaderRow();
            row.addCell("TX").setContentAsString("Truth X");
            row.addCell("TY").setContentAsString("Truth Y");
            row.addCell("TW").setContentAsString("Truth Width");
            row.addCell("TH").setContentAsString("Truth Height");
            row.addCell("TT").setContentAsString("Truth Type");
            row.addCell("OX").setContentAsString("Other X");
            row.addCell("OY").setContentAsString("Other Y");
            row.addCell("OW").setContentAsString("Other Width");
            row.addCell("OH").setContentAsString("Other Height");
            row.addCell("OT").setContentAsString("Other Type");
            row.addCell("M").setContentAsString("Match");
            for (LocatedObject truthObj : truthObjs) {
                this.updateType(truthObj, typeKey);
                row = sheet.addRow();
                row.addCell("TX").setContent(Integer.valueOf(truthObj.getX()));
                row.addCell("TY").setContent(Integer.valueOf(truthObj.getY()));
                row.addCell("TW").setContent(Integer.valueOf(truthObj.getWidth()));
                row.addCell("TH").setContent(Integer.valueOf(truthObj.getHeight()));
                row.addCell("TT").setNative(truthObj.getMetaData().containsKey(suffix) ? truthObj.getMetaData().get(suffix) : "?");
                row.addCell("OX").setMissing();
                row.addCell("OY").setMissing();
                row.addCell("OW").setMissing();
                row.addCell("OH").setMissing();
                row.addCell("OT").setMissing();
                row.addCell("M").setMissing();
                LocatedObject largestOverlapObj = null;
                double largestOverlap = 0.0;
                for (LocatedObject otherObj : otherObjs) {
                    double overlap = truthObj.overlapRatio(otherObj);
                    if (!(overlap > largestOverlap) || !(overlap >= this.m_MinOverlapRatio)) continue;
                    largestOverlap = overlap;
                    largestOverlapObj = otherObj;
                }
                if (largestOverlapObj == null) continue;
                this.updateType(largestOverlapObj, typeKey);
                row.getCell("OX").setContent(Integer.valueOf(largestOverlapObj.getX()));
                row.getCell("OY").setContent(Integer.valueOf(largestOverlapObj.getY()));
                row.getCell("OW").setContent(Integer.valueOf(largestOverlapObj.getWidth()));
                row.getCell("OH").setContent(Integer.valueOf(largestOverlapObj.getHeight()));
                row.addCell("OT").setNative(largestOverlapObj.getMetaData().containsKey(suffix) ? largestOverlapObj.getMetaData().get(suffix) : "?");
                row.getCell("M").setContent(Boolean.valueOf(!row.getCell("TT").isMissing() && row.getCell("TT").getContent().equals(row.getCell("OT").getContent())));
            }
        }
        if (sheet != null) {
            this.m_OutputToken = new Token(sheet);
        }
        return result;
    }
}

