/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.base.BaseRectangle;
import adams.core.option.OptionHandler;
import adams.data.report.Report;
import adams.data.report.ReportHandler;
import adams.flow.core.DataInfoActor;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import java.awt.Rectangle;
import java.util.Map;

public class ImageObjectInfo
extends AbstractTransformer
implements DataInfoActor {
    private static final long serialVersionUID = -5644432725273726622L;
    protected String m_Prefix;
    protected String m_Index;
    protected InfoType m_Type;

    public String globalInfo() {
        return "Outputs the requested type of information for either the incoming " + Utils.classToString(LocatedObject.class) + " or the specified image object in the report.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("prefix", "prefix", (Object)"Object.");
        this.m_OptionManager.add("index", "index", (Object)"");
        this.m_OptionManager.add("type", "type", (Object)InfoType.X);
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The report field prefix used in the report.";
    }

    public void setIndex(String value) {
        this.m_Index = value;
        this.reset();
    }

    public String getIndex() {
        return this.m_Index;
    }

    public String indexTipText() {
        return "The index of the object to retrieve the information for.";
    }

    public void setType(InfoType value) {
        this.m_Type = value;
        this.reset();
    }

    public InfoType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of information to generate.";
    }

    public Class[] accepts() {
        return new Class[]{ReportHandler.class, Report.class, LocatedObject.class};
    }

    public Class[] generates() {
        switch (this.m_Type) {
            case X: 
            case Y: 
            case WIDTH: 
            case HEIGHT: {
                return new Class[]{Integer.class};
            }
            case META_DATA: {
                return new Class[]{Map.class};
            }
            case RECTANGLE: {
                return new Class[]{Rectangle.class};
            }
            case BASE_RECTANGLE: {
                return new Class[]{BaseRectangle.class};
            }
        }
        throw new IllegalStateException("Unhandled type: " + (Object)((Object)this.m_Type));
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"prefix", (Object)this.m_Prefix, (String)"prefix: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"index", (Object)(this.m_Index.isEmpty() ? "-none-" : this.m_Index), (String)", index: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"type", (Object)((Object)this.m_Type), (String)", type: ");
        return result;
    }

    protected String doExecute() {
        String result;
        block16: {
            block17: {
                result = null;
                Report report = null;
                LocatedObject obj = null;
                if (this.m_InputToken.hasPayload(ReportHandler.class)) {
                    report = ((ReportHandler)this.m_InputToken.getPayload(ReportHandler.class)).getReport();
                } else if (this.m_InputToken.hasPayload(Report.class)) {
                    report = (Report)this.m_InputToken.getPayload(Report.class);
                } else if (this.m_InputToken.hasPayload(LocatedObject.class)) {
                    obj = (LocatedObject)this.m_InputToken.getPayload(LocatedObject.class);
                } else {
                    result = this.m_InputToken.unhandledData();
                }
                if (result != null) break block16;
                if (report != null) {
                    LocatedObjects objs = LocatedObjects.fromReport(report, this.m_Prefix);
                    obj = objs.find(this.m_Index);
                }
                if (obj == null) break block17;
                switch (this.m_Type) {
                    case X: {
                        this.m_OutputToken = new Token((Object)obj.getX());
                        break block16;
                    }
                    case Y: {
                        this.m_OutputToken = new Token((Object)obj.getY());
                        break block16;
                    }
                    case WIDTH: {
                        this.m_OutputToken = new Token((Object)obj.getWidth());
                        break block16;
                    }
                    case HEIGHT: {
                        this.m_OutputToken = new Token((Object)obj.getHeight());
                        break block16;
                    }
                    case META_DATA: {
                        this.m_OutputToken = new Token(obj.getMetaData());
                        break block16;
                    }
                    case RECTANGLE: {
                        this.m_OutputToken = new Token((Object)obj.getRectangle());
                        break block16;
                    }
                    case BASE_RECTANGLE: {
                        this.m_OutputToken = new Token((Object)new BaseRectangle(obj.getRectangle()));
                        break block16;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled type: " + (Object)((Object)this.m_Type));
                    }
                }
            }
            result = "Index not found: " + this.m_Index;
        }
        return result;
    }

    public static enum InfoType {
        X,
        Y,
        WIDTH,
        HEIGHT,
        META_DATA,
        RECTANGLE,
        BASE_RECTANGLE;

    }
}

