/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.base.BaseRegExp;
import adams.core.option.OptionHandler;
import adams.data.image.AbstractImageContainer;
import adams.data.report.AbstractField;
import adams.data.report.MutableReportHandler;
import adams.data.report.Report;
import adams.data.report.ReportHandler;
import adams.flow.control.StorageName;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;

public class MergeObjectLocations
extends AbstractTransformer {
    private static final long serialVersionUID = 8175397929496972306L;
    protected StorageName m_StorageName;
    protected String m_Prefix;
    protected OverlapAction m_OverlapAction;
    protected NoOverlapAction m_NoOverlapAction;
    protected boolean m_CheckType;
    protected String m_TypeSuffix;
    protected BaseRegExp m_TypeFind;
    protected String m_TypeReplace;
    protected double m_MinOverlapRatio;

    public String globalInfo() {
        return "Merges the object locations in the report of the container passing through with the one obtained from storage.\nThe 'overlap action' determines what to do if objects overlap.\nWith the 'check type' you can still trigger a 'skip' if the type values of the two overlapping objects differ.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("storage-name", "storageName", (Object)new StorageName());
        this.m_OptionManager.add("prefix", "prefix", (Object)"Object.");
        this.m_OptionManager.add("overlap-action", "overlapAction", (Object)OverlapAction.SKIP);
        this.m_OptionManager.add("no-overlap-action", "noOverlapAction", (Object)NoOverlapAction.KEEP);
        this.m_OptionManager.add("check-type", "checkType", (Object)false);
        this.m_OptionManager.add("type-suffix", "typeSuffix", (Object)"");
        this.m_OptionManager.add("type-find", "typeFind", (Object)new BaseRegExp(""));
        this.m_OptionManager.add("type-replace", "typeReplace", (Object)"");
        this.m_OptionManager.add("min-overlap-ratio", "minOverlapRatio", (Object)0.0, (Number)0.0, (Number)1.0);
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name of the storage item to merge with (Report or ReportHandler).";
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The report field prefix used in the report.";
    }

    public void setOverlapAction(OverlapAction value) {
        this.m_OverlapAction = value;
        this.reset();
    }

    public OverlapAction getOverlapAction() {
        return this.m_OverlapAction;
    }

    public String overlapActionTipText() {
        return "The action to take when an object from this and the other report overlap.";
    }

    public void setNoOverlapAction(NoOverlapAction value) {
        this.m_NoOverlapAction = value;
        this.reset();
    }

    public NoOverlapAction getNoOverlapAction() {
        return this.m_NoOverlapAction;
    }

    public String noOverlapActionTipText() {
        return "The action to take when an object has no overlaps at all.";
    }

    public void setCheckType(boolean value) {
        this.m_CheckType = value;
        this.reset();
    }

    public boolean getCheckType() {
        return this.m_CheckType;
    }

    public String checkTypeTipText() {
        return "If enabled, the type of the objects gets checked as well.";
    }

    public void setTypeSuffix(String value) {
        this.m_TypeSuffix = value;
        this.reset();
    }

    public String getTypeSuffix() {
        return this.m_TypeSuffix;
    }

    public String typeSuffixTipText() {
        return "The report field suffix for the type used in the report (ignored if empty).";
    }

    public void setTypeFind(BaseRegExp value) {
        this.m_TypeFind = value;
        this.reset();
    }

    public BaseRegExp getTypeFind() {
        return this.m_TypeFind;
    }

    public String typeFindTipText() {
        return "The regular expression to apply to the type, ignored if empty.";
    }

    public void setTypeReplace(String value) {
        this.m_TypeReplace = value;
        this.reset();
    }

    public String getTypeReplace() {
        return this.m_TypeReplace;
    }

    public String typeReplaceTipText() {
        return "The replacement string to use with the replacement regular expression.";
    }

    public void setMinOverlapRatio(double value) {
        if (this.getOptionManager().isValid("minOverlapRatio", (Number)value)) {
            this.m_MinOverlapRatio = value;
            this.reset();
        }
    }

    public double getMinOverlapRatio() {
        return this.m_MinOverlapRatio;
    }

    public String minOverlapRatioTipText() {
        return "The minimum ratio that an overlap must have before being considered an actual overlap.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"storageName", (Object)this.m_StorageName, (String)"storage: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"prefix", (Object)this.m_Prefix, (String)", prefix: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"overlapAction", (Object)((Object)this.m_OverlapAction), (String)", overlap: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"noOverlapAction", (Object)((Object)this.m_NoOverlapAction), (String)", no-overlap: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"typeSuffix", (Object)(this.m_TypeSuffix.isEmpty() ? "-ignored-" : this.m_TypeSuffix), (String)", type suffix: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"minOverlapRatio", (Object)this.m_MinOverlapRatio, (String)", overlap ratio: ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{AbstractImageContainer.class, Report.class, ReportHandler.class};
    }

    public Class[] generates() {
        return new Class[]{AbstractImageContainer.class, Report.class, ReportHandler.class};
    }

    protected String doExecute() {
        String result = null;
        Object output = null;
        Report thisReport = null;
        Report otherReport = null;
        String typeKey = this.m_TypeSuffix.startsWith(".") ? this.m_TypeSuffix.substring(1) : this.m_TypeSuffix;
        if (this.m_InputToken.getPayload() instanceof AbstractImageContainer) {
            thisReport = ((AbstractImageContainer)this.m_InputToken.getPayload()).getReport();
        } else if (this.m_InputToken.getPayload() instanceof Report) {
            thisReport = (Report)this.m_InputToken.getPayload();
        } else if (this.m_InputToken.getPayload() instanceof ReportHandler) {
            thisReport = ((ReportHandler)this.m_InputToken.getPayload()).getReport();
        } else {
            result = "Unsupported input class: " + Utils.classToString((Object)this.m_InputToken.getPayload());
        }
        if (thisReport != null) {
            Object obj = this.getStorageHandler().getStorage().get(this.m_StorageName);
            if (obj == null) {
                result = "Failed to retrieve storage item: " + this.m_StorageName;
            } else if (obj instanceof Report) {
                otherReport = (Report)obj;
            } else if (obj instanceof ReportHandler) {
                otherReport = ((ReportHandler)obj).getReport();
            } else {
                result = "Unhandled type of storage item '" + this.m_StorageName + "': " + Utils.classToString((Object)obj);
            }
        }
        if (otherReport != null) {
            LocatedObjects thisObjs = LocatedObjects.fromReport(thisReport, this.m_Prefix);
            LocatedObjects otherObjs = LocatedObjects.fromReport(otherReport, this.m_Prefix);
            LocatedObjects mergedObjs = new LocatedObjects();
            if (thisObjs.size() == 0) {
                mergedObjs = otherObjs;
            } else {
                for (LocatedObject thisObj : thisObjs) {
                    boolean add = true;
                    int overlaps = 0;
                    for (LocatedObject otherObj : otherObjs) {
                        if (thisObj.overlapRatio(otherObj) >= this.m_MinOverlapRatio) {
                            ++overlaps;
                            switch (this.m_OverlapAction) {
                                case SKIP: {
                                    add = false;
                                    break;
                                }
                                case KEEP: {
                                    if (this.m_CheckType && thisObj.getMetaData().containsKey(this.m_TypeSuffix) && otherObj.getMetaData().containsKey(this.m_TypeSuffix)) {
                                        add = thisObj.getMetaData().get(this.m_TypeSuffix).equals(otherObj.getMetaData().get(this.m_TypeSuffix));
                                    }
                                    if (!add) break;
                                    for (String key : otherObj.getMetaData().keySet()) {
                                        thisObj.getMetaData().putIfAbsent(key, otherObj.getMetaData().get(key));
                                    }
                                    break;
                                }
                                default: {
                                    throw new IllegalStateException("Unhandled overlap action: " + (Object)((Object)this.m_OverlapAction));
                                }
                            }
                        }
                        if (add) continue;
                        break;
                    }
                    if (overlaps == 0) {
                        switch (this.m_NoOverlapAction) {
                            case SKIP: {
                                add = false;
                                break;
                            }
                            case KEEP: {
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unhandled no-overlap action: " + (Object)((Object)this.m_NoOverlapAction));
                            }
                        }
                    }
                    if (!add) continue;
                    if (!typeKey.isEmpty() && !this.m_TypeFind.isEmpty() && thisObj.getMetaData().containsKey(typeKey)) {
                        String typeNew = thisObj.getMetaData().get(typeKey).toString();
                        typeNew = typeNew.replaceFirst(this.m_TypeFind.getValue(), this.m_TypeReplace);
                        thisObj.getMetaData().put(typeKey, typeNew);
                    }
                    mergedObjs.add(thisObj);
                }
            }
            try {
                Report newReport = (Report)thisReport.getClass().newInstance();
                for (AbstractField field : thisReport.getFields()) {
                    if (field.getName().startsWith(this.m_Prefix)) continue;
                    newReport.addField(field);
                    newReport.setValue(field, thisReport.getValue(field));
                }
                newReport.mergeWith(mergedObjs.toReport(this.m_Prefix));
                if (this.m_InputToken.getPayload() instanceof AbstractImageContainer) {
                    output = this.m_InputToken.getPayload();
                    ((AbstractImageContainer)output).setReport(newReport);
                } else if (this.m_InputToken.getPayload() instanceof MutableReportHandler) {
                    output = this.m_InputToken.getPayload();
                    ((MutableReportHandler)output).setReport(newReport);
                } else {
                    output = newReport;
                }
            }
            catch (Exception e) {
                result = this.handleException("Failed to create new report with merged objects!", e);
                output = null;
            }
        }
        if (output != null) {
            this.m_OutputToken = new Token(output);
        }
        return result;
    }

    public static enum NoOverlapAction {
        SKIP,
        KEEP;

    }

    public static enum OverlapAction {
        SKIP,
        KEEP;

    }
}

