/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.data.image.AbstractImageContainer;
import adams.data.report.AbstractField;
import adams.data.report.Report;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;

public class RemoveImageObject
extends AbstractTransformer {
    private static final long serialVersionUID = -5644432725273726622L;
    protected String m_Prefix;
    protected String m_Index;

    public String globalInfo() {
        return "Removes the specified image object.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("prefix", "prefix", (Object)"Object.");
        this.m_OptionManager.add("index", "index", (Object)"");
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The report field prefix used in the report.";
    }

    public void setIndex(String value) {
        this.m_Index = value;
        this.reset();
    }

    public String getIndex() {
        return this.m_Index;
    }

    public String indexTipText() {
        return "The index of the object to remove.";
    }

    public Class[] accepts() {
        return new Class[]{AbstractImageContainer.class, Report.class};
    }

    public Class[] generates() {
        return new Class[]{AbstractImageContainer.class, Report.class};
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"prefix", (Object)this.m_Prefix, (String)"prefix: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"index", (Object)(this.m_Index.isEmpty() ? "-none-" : this.m_Index), (String)", index: ");
        return result;
    }

    protected String doExecute() {
        String result = null;
        Report report = null;
        if (this.m_InputToken.getPayload() instanceof AbstractImageContainer) {
            report = ((AbstractImageContainer)this.m_InputToken.getPayload()).getReport();
        } else if (this.m_InputToken.getPayload() instanceof Report) {
            report = (Report)this.m_InputToken.getPayload();
        } else {
            result = "Unhandled input: " + Utils.classToString((Object)this.m_InputToken.getPayload());
        }
        if (result == null) {
            LocatedObjects objs = LocatedObjects.fromReport(report, this.m_Prefix);
            LocatedObject obj = objs.find(this.m_Index);
            if (obj != null) {
                String prefix = this.m_Prefix + obj.getIndexString() + ".";
                for (AbstractField field : report.getFields()) {
                    if (!field.getName().startsWith(prefix)) continue;
                    report.removeValue(field);
                    if (!this.isLoggingEnabled()) continue;
                    this.getLogger().info("Removed: " + field);
                }
            } else {
                this.getLogger().warning("Index not found: " + this.m_Index);
            }
            this.m_OutputToken = new Token(this.m_InputToken.getPayload());
        }
        return result;
    }
}

