/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.draw;

import adams.data.image.BufferedImageContainer;
import adams.flow.transformer.draw.AbstractDrawObjectsFromReport;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.List;

public class ObjectCentersFromReport
extends AbstractDrawObjectsFromReport {
    private static final long serialVersionUID = 6356419097401574024L;
    protected int m_Diameter;

    public String globalInfo() {
        return "Displays the centers of objects in the image, using data from the attached report.\nSuffixes:\n.x\n.y\n.width\n.height\nOptionally, if type information is available per object, the locations can be displayed in distinct colors per type. The type itself can be displayed as well.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("diameter", "diameter", (Object)10, (Number)-1, null);
    }

    public void setDiameter(int value) {
        if (this.getOptionManager().isValid("diameter", (Number)value)) {
            this.m_Diameter = value;
            this.reset();
        }
    }

    public int getDiameter() {
        return this.m_Diameter;
    }

    public String diameterTipText() {
        return "The diameter of the circle that is drawn; < 1 to use the rectangle's dimensions to draw an ellipse.";
    }

    @Override
    protected String doDraw(BufferedImageContainer image, List<Rectangle> locations) {
        Graphics g = ((BufferedImage)image.getImage()).getGraphics();
        g.setColor(this.getColor());
        for (Rectangle rect : locations) {
            String label;
            if (this.getUseColorsPerType() && this.m_Overlays.hasColor(rect)) {
                g.setColor(this.m_Overlays.getColor(rect));
            }
            if (this.m_Diameter < 1) {
                g.fillOval((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
            } else {
                g.fillOval((int)(rect.getCenterX() - (double)this.m_Diameter), (int)(rect.getCenterY() - (double)this.m_Diameter), this.m_Diameter * 2, this.m_Diameter * 2);
            }
            if (!this.m_Overlays.hasLabel(rect) || (label = this.m_Overlays.getLabel(rect)) == null) continue;
            g.drawString(label, (int)(rect.getX() + rect.getWidth()), (int)rect.getY());
        }
        return null;
    }
}

