/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.draw;

import adams.data.image.BufferedImageContainer;
import adams.flow.transformer.draw.AbstractDrawObjectsFromReport;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.List;

public class ObjectLocationsFromReport
extends AbstractDrawObjectsFromReport {
    private static final long serialVersionUID = 6356419097401574024L;

    public String globalInfo() {
        return "Displays the locations of objects in the image, using data from the attached report.\nSuffixes:\n.x\n.y\n.width\n.height\nOptionally, if type information is available per object, the locations can be displayed in distinct colors per type. The type itself can be displayed as well.";
    }

    @Override
    protected String doDraw(BufferedImageContainer image, List<Rectangle> locations) {
        Graphics g = ((BufferedImage)image.getImage()).getGraphics();
        g.setColor(this.getColor());
        for (Rectangle rect : locations) {
            String label;
            if (this.getUseColorsPerType() && this.m_Overlays.hasColor(rect)) {
                g.setColor(this.m_Overlays.getColor(rect));
            }
            g.drawRect((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
            if (!this.m_Overlays.hasLabel(rect) || (label = this.m_Overlays.getLabel(rect)) == null) continue;
            g.drawString(label, (int)(rect.getX() + rect.getWidth()), (int)rect.getY());
        }
        return null;
    }
}

