/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.locateobjects;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.image.transformer.crop.AbstractCropAlgorithm;
import adams.data.image.transformer.crop.NoCrop;
import adams.flow.transformer.locateobjects.AbstractMetaObjectLocator;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import java.awt.image.BufferedImage;

public class CroppedLocator
extends AbstractMetaObjectLocator {
    private static final long serialVersionUID = -3902398122751433577L;
    protected AbstractCropAlgorithm m_Crop;

    public String globalInfo() {
        return "Uses the defined crop algorithm to first crop the image before locating objects. The locations get adjusted to fit the original image.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("crop", "crop", (Object)new NoCrop());
    }

    public void setCrop(AbstractCropAlgorithm value) {
        this.m_Crop = value;
        this.reset();
    }

    public AbstractCropAlgorithm getCrop() {
        return this.m_Crop;
    }

    public String cropTipText() {
        return "The crop algorithm to apply to the image.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"crop", (Object)this.m_Crop, (String)"crop: ");
        result = result + ", " + super.getQuickInfo();
        return result;
    }

    @Override
    protected LocatedObjects doLocate(BufferedImage image, boolean annotateOnly) {
        int top;
        int left;
        BufferedImage cropped;
        if (this.m_Crop instanceof NoCrop) {
            cropped = image;
            left = 0;
            top = 0;
        } else {
            cropped = this.m_Crop.crop(image);
            left = (int)this.m_Crop.getTopLeft().getX();
            top = (int)this.m_Crop.getTopLeft().getY();
        }
        LocatedObjects base = this.m_Locator.locate(cropped);
        LocatedObjects result = new LocatedObjects();
        for (LocatedObject obj : base) {
            LocatedObject adjusted = new LocatedObject(annotateOnly ? null : obj.getImage(), left + obj.getX(), top + obj.getY(), obj.getWidth(), obj.getHeight());
            result.add(adjusted);
        }
        return result;
    }
}

