/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.locateobjects;

import adams.core.CloneHandler;
import adams.core.base.QuadrilateralLocation;
import adams.data.image.BufferedImageHelper;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class LocatedObject
implements Serializable,
CloneHandler<LocatedObject> {
    private static final long serialVersionUID = 8662599273386642371L;
    protected BufferedImage m_Image;
    protected int m_X;
    protected int m_Y;
    protected int m_Width;
    protected int m_Height;
    protected Rectangle m_Actual;
    protected Map<String, Object> m_MetaData;

    public LocatedObject(BufferedImage image, int x, int y, int width, int height) {
        this(image, x, y, width, height, null);
    }

    public LocatedObject(BufferedImage image, int x, int y, int width, int height, Map<String, Object> metaData) {
        this.m_Image = image;
        this.m_X = x;
        this.m_Y = y;
        this.m_Width = width;
        this.m_Height = height;
        this.m_MetaData = metaData == null ? new HashMap() : metaData;
        this.m_Actual = null;
    }

    public LocatedObject getClone() {
        return new LocatedObject(this.m_Image != null ? BufferedImageHelper.deepCopy((BufferedImage)this.m_Image) : null, this.m_X, this.m_Y, this.m_Width, this.m_Height, this.getMetaData(true));
    }

    public BufferedImage getImage() {
        return this.m_Image;
    }

    public int getX() {
        return this.m_X;
    }

    public int getY() {
        return this.m_Y;
    }

    public int getWidth() {
        return this.m_Width;
    }

    public int getHeight() {
        return this.m_Height;
    }

    public String getIndexString() {
        String result = null;
        if (this.getMetaData() != null && this.getMetaData().containsKey("index")) {
            result = "" + this.getMetaData().get("index");
        }
        return result;
    }

    public int getIndex() {
        int result = -1;
        String index = this.getIndexString();
        if (index != null) {
            try {
                result = Integer.parseInt(index);
            }
            catch (Exception e) {
                result = -1;
            }
        }
        return result;
    }

    public Map<String, Object> getMetaData() {
        return this.getMetaData(false);
    }

    public Map<String, Object> getMetaData(boolean copy) {
        if (!copy) {
            return this.m_MetaData;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.putAll(this.m_MetaData);
        return result;
    }

    public Rectangle getActual() {
        if (this.m_Actual == null) {
            this.m_Actual = this.getRectangle();
        }
        return this.m_Actual;
    }

    public void scale(double scale) {
        this.m_Actual = this.getRectangle(scale);
    }

    public QuadrilateralLocation getLocation() {
        return new QuadrilateralLocation(this.m_X, this.m_Y, this.m_X + this.m_Width - 1, this.m_Y, this.m_X + this.m_Width - 1, this.m_Y + this.m_Height - 1, this.m_X, this.m_Y + this.m_Height - 1);
    }

    public Rectangle getRectangle() {
        return this.getRectangle(1.0);
    }

    public Rectangle getRectangle(double scale) {
        return new Rectangle((int)((double)this.getX() * scale), (int)((double)this.getY() * scale), (int)((double)this.getWidth() * scale), (int)((double)this.getHeight() * scale));
    }

    protected boolean inRange(int value, int min, int max) {
        return value >= min && value <= max;
    }

    public boolean overlap(LocatedObject other) {
        int thisLeft = this.getX();
        int thisRight = this.getX() + this.getWidth() - 1;
        int thisTop = this.getY();
        int thisBottom = this.getY() + this.getHeight() - 1;
        int otherLeft = other.getX();
        int otherRight = other.getX() + other.getWidth() - 1;
        int otherTop = other.getY();
        int otherBottom = other.getY() + other.getHeight() - 1;
        boolean xOverlap = this.inRange(thisLeft, otherLeft, otherRight) || this.inRange(otherLeft, thisLeft, thisRight);
        boolean yOverlap = this.inRange(thisTop, otherTop, otherBottom) || this.inRange(otherTop, thisTop, thisBottom);
        return xOverlap && yOverlap;
    }

    public Rectangle overlapRectangle(LocatedObject other) {
        if (!this.overlap(other)) {
            return null;
        }
        return this.getRectangle().intersection(other.getRectangle());
    }

    public double overlapRatio(LocatedObject other) {
        Rectangle overlap = this.overlapRectangle(other);
        if (overlap == null) {
            return 0.0;
        }
        return overlap.getWidth() * overlap.getHeight() / (double)(this.getWidth() * this.getHeight());
    }

    public String toString() {
        if (this.m_Image != null) {
            return "@" + this.m_Image.hashCode() + ", x=" + this.m_X + ", y=" + this.m_Y + ", w=" + this.m_Width + ", h=" + this.m_Height;
        }
        return "x=" + this.m_X + ", y=" + this.m_Y + ", w=" + this.m_Width + ", h=" + this.m_Height;
    }
}

