/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.pixelselector;

import adams.core.CleanUpHandler;
import adams.data.image.AbstractImageContainer;
import adams.data.report.Report;
import adams.flow.transformer.pixelselector.AbstractPixelSelectorAction;
import adams.flow.transformer.pixelselector.AbstractPixelSelectorOverlay;
import adams.gui.core.BasePanel;
import adams.gui.core.BasePopupMenu;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.CustomPopupMenuProvider;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.goe.GenericArrayEditorDialog;
import adams.gui.visualization.image.ImageOverlay;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.report.ReportFactory;
import adams.gui.visualization.report.reportfactory.AddField;
import adams.gui.visualization.report.reportfactory.CopyFieldName;
import adams.gui.visualization.report.reportfactory.CopyFieldValue;
import adams.gui.visualization.report.reportfactory.ModifyValue;
import adams.gui.visualization.report.reportfactory.RemoveField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class PixelSelectorPanel
extends BasePanel
implements CustomPopupMenuProvider,
CleanUpHandler,
TableModelListener,
MenuBarProvider {
    private static final long serialVersionUID = 8742441848602035650L;
    public static final int CANCEL_OPTION = 0;
    public static final int APPROVE_OPTION = 1;
    protected AbstractImageContainer m_Image;
    protected BaseSplitPane m_SplitPane;
    protected ImagePanel m_ImagePanel;
    protected ReportFactory.Table m_ReportTable;
    protected JButton m_ButtonOK;
    protected JButton m_ButtonCancel;
    protected int m_Result;
    protected HashSet<ActionListener> m_ActionListeners;
    protected AbstractPixelSelectorAction[] m_Actions;
    protected JMenuBar m_MenuBar;
    protected Hashtable<Class, Object> m_LastActionResult;

    protected void initialize() {
        super.initialize();
        this.m_Image = null;
        this.m_Result = 0;
        this.m_ActionListeners = new HashSet();
        this.m_Actions = new AbstractPixelSelectorAction[0];
        this.m_LastActionResult = new Hashtable();
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_SplitPane = new BaseSplitPane();
        this.m_SplitPane.setOneTouchExpandable(true);
        this.m_SplitPane.setResizeWeight(1.0);
        this.add((Component)this.m_SplitPane, "Center");
        this.m_ImagePanel = new ImagePanel();
        this.m_ImagePanel.setCustomPopupMenuProvider((CustomPopupMenuProvider)this);
        this.m_SplitPane.setLeftComponent((Component)this.m_ImagePanel);
        this.m_ReportTable = new ReportFactory.Table(new Report());
        this.m_ReportTable.setSelectionMode(2);
        this.m_ReportTable.setPopupActions(new String[]{CopyFieldName.class.getName(), CopyFieldValue.class.getName(), ModifyValue.class.getName(), "-", RemoveField.class.getName(), AddField.class.getName()});
        this.m_SplitPane.setRightComponent((Component)new BaseScrollPane((Component)this.m_ReportTable));
        JPanel panel = new JPanel(new FlowLayout(2));
        this.add(panel, "South");
        this.m_ButtonOK = new JButton("Accept");
        this.m_ButtonOK.setMnemonic('A');
        this.m_ButtonOK.setIcon(GUIHelper.getIcon((String)"accept.png"));
        this.m_ButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PixelSelectorPanel.this.closeDialog(1);
            }
        });
        panel.add(this.m_ButtonOK);
        this.m_ButtonCancel = new JButton("Cancel");
        this.m_ButtonCancel.setMnemonic('C');
        this.m_ButtonCancel.setIcon(GUIHelper.getIcon((String)"delete.gif"));
        this.m_ButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PixelSelectorPanel.this.closeDialog(0);
            }
        });
        panel.add(this.m_ButtonCancel);
    }

    public void setSplitterPosition(int value) {
        this.m_SplitPane.setDividerLocation(value);
    }

    public int getSplitterPosition() {
        return this.m_SplitPane.getDividerLocation();
    }

    public void setActions(AbstractPixelSelectorAction[] value) {
        this.m_Actions = value;
    }

    public AbstractPixelSelectorAction[] getActions() {
        return this.m_Actions;
    }

    public void setImage(AbstractImageContainer value) {
        this.m_ReportTable.getModel().removeTableModelListener(this);
        this.m_Image = value;
        if (this.m_Image == null) {
            this.m_ImagePanel.setCurrentImage((BufferedImage)null);
        } else {
            this.m_ImagePanel.setCurrentImage(this.m_Image.toBufferedImage());
        }
        this.update();
        this.m_ReportTable.getModel().addTableModelListener(this);
    }

    public boolean hasImage() {
        return this.m_Image != null;
    }

    public AbstractImageContainer getImage() {
        return this.m_Image;
    }

    public void addActionListener(ActionListener l) {
        this.m_ActionListeners.add(l);
    }

    public void removeActionListener(ActionListener l) {
        this.m_ActionListeners.remove(l);
    }

    protected void notifyActionListeners(int button) {
        String cmd = button == 1 ? "OK" : "Cancel";
        ActionEvent e = new ActionEvent(this, button, cmd);
        for (ActionListener l : this.m_ActionListeners) {
            l.actionPerformed(e);
        }
    }

    public void clearImageOverlays() {
        this.m_ImagePanel.clearImageOverlays();
    }

    public void addImageOverlay(ImageOverlay io) {
        if (io instanceof AbstractPixelSelectorOverlay) {
            ((AbstractPixelSelectorOverlay)io).setImage(this.m_Image);
        }
        this.m_ImagePanel.addImageOverlay(io);
    }

    public void removeImageOverlay(ImageOverlay io) {
        this.m_ImagePanel.removeImageOverlay(io);
    }

    public Iterator<ImageOverlay> imageOverlays() {
        return this.m_ImagePanel.imageOverlays();
    }

    protected void closeDialog(int result) {
        this.m_Result = result;
        this.notifyActionListeners(this.m_Result);
        this.closeParent();
    }

    protected void editOverlays() {
        ArrayList<AbstractPixelSelectorOverlay> list = new ArrayList<AbstractPixelSelectorOverlay>();
        Iterator iter = this.m_ImagePanel.imageOverlays();
        while (iter.hasNext()) {
            AbstractPixelSelectorOverlay overlay = ((AbstractPixelSelectorOverlay)((Object)iter.next())).shallowCopy();
            list.add(overlay);
        }
        GenericArrayEditorDialog dialog = this.getParentDialog() != null ? new GenericArrayEditorDialog(this.getParentDialog()) : new GenericArrayEditorDialog(this.getParentFrame());
        dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        dialog.setTitle("Overlays");
        dialog.setCurrent((Object)list.toArray(new AbstractPixelSelectorOverlay[list.size()]));
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
        if (dialog.getResult() == 0) {
            this.m_ImagePanel.clearImageOverlays();
            AbstractPixelSelectorOverlay[] overlays = (AbstractPixelSelectorOverlay[])dialog.getCurrent();
            for (int i = 0; i < overlays.length; ++i) {
                this.m_ImagePanel.addImageOverlay((ImageOverlay)overlays[i]);
            }
        }
        this.update();
    }

    public boolean hasLastActionResult(Class cls) {
        return this.m_LastActionResult.containsKey(cls);
    }

    public void setLastActionResult(Class cls, Object value) {
        if (value == null) {
            this.m_LastActionResult.remove(cls);
        } else {
            this.m_LastActionResult.put(cls, value);
        }
    }

    public Object getLastActionResult(Class cls) {
        return this.m_LastActionResult.get(cls);
    }

    public int getResult() {
        return this.m_Result;
    }

    public BasePopupMenu getCustomPopupMenu(MouseEvent e) {
        BasePopupMenu result = null;
        if (this.m_Actions.length > 0) {
            Point loc = this.m_ImagePanel.mouseToPixelLocation(e.getPoint());
            result = new BasePopupMenu();
            for (AbstractPixelSelectorAction action : this.m_Actions) {
                action.setMousePosition(e.getPoint());
                action.setPixelPosition(loc);
                action.setPanel(this);
                JMenuItem menuitem = new JMenuItem((Action)((Object)action));
                result.add(menuitem);
            }
        }
        return result;
    }

    public JMenuBar getMenuBar() {
        JMenuBar result;
        if (this.m_MenuBar == null) {
            result = new JMenuBar();
            JMenu menu = new JMenu("Dialog");
            menu.setMnemonic('D');
            result.add(menu);
            JMenuItem menuitem = new JMenuItem("Cancel");
            menuitem.setMnemonic('C');
            menuitem.setIcon(GUIHelper.getIcon((String)"delete.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PixelSelectorPanel.this.closeDialog(0);
                }
            });
            menu.add(menuitem);
            menuitem = new JMenuItem("Accept");
            menuitem.setMnemonic('A');
            menuitem.setIcon(GUIHelper.getIcon((String)"accept.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PixelSelectorPanel.this.closeDialog(1);
                }
            });
            menu.addSeparator();
            menu.add(menuitem);
            menu = new JMenu("View");
            menu.setMnemonic('V');
            result.add(menu);
            menuitem = new JMenuItem("Overlays...");
            menuitem.setMnemonic('O');
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PixelSelectorPanel.this.editOverlays();
                }
            });
            menu.add(menuitem);
            this.m_MenuBar = result;
        } else {
            result = this.m_MenuBar;
        }
        return result;
    }

    public void updateReport() {
        if (this.m_Image != null) {
            this.m_ReportTable.setReport(this.m_Image.getReport());
        } else {
            this.m_ReportTable.setReport(new Report());
        }
        this.m_ReportTable.setOptimalColumnWidth();
    }

    public void updateImage() {
        Iterator<ImageOverlay> overlays = this.imageOverlays();
        while (overlays.hasNext()) {
            ImageOverlay overlay = overlays.next();
            if (!(overlay instanceof AbstractPixelSelectorOverlay)) continue;
            ((AbstractPixelSelectorOverlay)overlay).setImage(this.m_Image);
        }
        this.m_ImagePanel.repaint();
    }

    public void update() {
        this.updateReport();
        this.updateImage();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.updateImage();
    }

    public void cleanUp() {
        this.m_ActionListeners.clear();
        this.m_Image = null;
        this.m_Actions = new AbstractPixelSelectorAction[0];
    }
}

