/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.core.CleanUpHandler;
import adams.core.MessageCollection;
import adams.core.Utils;
import adams.data.image.AbstractImageContainer;
import adams.data.io.input.AbstractImageReader;
import adams.data.io.input.FlowReader;
import adams.data.io.output.FlowWriter;
import adams.flow.control.SubProcess;
import adams.flow.core.Actor;
import adams.flow.core.Compatibility;
import adams.flow.transformer.locateobjects.AbstractObjectLocator;
import adams.flow.transformer.locateobjects.PassThrough;
import adams.gui.chooser.FlowFileChooser;
import adams.gui.chooser.ImageFileChooser;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.core.RecentFilesHandlerWithCommandline;
import adams.gui.core.TitleGenerator;
import adams.gui.core.Undo;
import adams.gui.event.RecentItemEvent;
import adams.gui.event.RecentItemListener;
import adams.gui.flow.FlowPanel;
import adams.gui.goe.GenericObjectEditorDialog;
import adams.gui.tools.ImageProcessorSubPanel;
import adams.gui.tools.ImageProcessorTabbedPane;
import adams.gui.visualization.image.ImageOverlay;
import adams.gui.visualization.image.ImageViewerPanel;
import adams.gui.visualization.image.NullOverlay;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingWorker;

public class ImageProcessorPanel
extends BasePanel
implements MenuBarProvider,
CleanUpHandler {
    private static final long serialVersionUID = 5882173310359920644L;
    public static final String SESSION_FILE = "ImageProcessorSession.props";
    protected BaseSplitPane m_SplitPane;
    protected ImageProcessorTabbedPane m_TabbedPane;
    protected JMenuBar m_MenuBar;
    protected JMenuItem m_MenuItemFileOpen;
    protected JMenu m_MenuItemFileLoadRecent;
    protected JMenuItem m_MenuItemFileClose;
    protected JMenuItem m_MenuItemViewHorizontal;
    protected JMenuItem m_MenuItemViewVertical;
    protected JMenuItem m_MenuItemEditUndo;
    protected JMenuItem m_MenuItemEditRedo;
    protected JMenuItem m_MenuViewLocateObjects;
    protected JMenuItem m_MenuViewRemoveOverlays;
    protected RecentFilesHandlerWithCommandline<JMenu> m_RecentFilesHandler;
    protected TitleGenerator m_TitleGenerator;
    protected ImageFileChooser m_FileChooserImage;
    protected FlowFileChooser m_FileChooserFlow;
    protected FlowPanel m_PanelFlow;
    protected JLabel m_LabelProgress;
    protected JButton m_ButtonNew;
    protected JButton m_ButtonLoad;
    protected JButton m_ButtonSave;
    protected JButton m_ButtonCheck;
    protected JButton m_ButtonRun;
    protected AbstractObjectLocator m_LastObjectLocatorOriginal;
    protected AbstractObjectLocator m_LastObjectLocatorProcessed;
    protected ImageOverlay m_LastImageOverlayOriginal;
    protected ImageOverlay m_LastImageOverlayProcessed;

    protected void initialize() {
        super.initialize();
        this.m_RecentFilesHandler = null;
        this.m_TitleGenerator = new TitleGenerator("Image processor", true);
        this.m_FileChooserImage = new ImageFileChooser();
        this.m_FileChooserImage.setCurrentDirectory(new File(ImageViewerPanel.getProperties().getPath("InitialDir", "%h")));
        this.m_FileChooserImage.setAutoAppendExtension(true);
        this.m_FileChooserImage.setMultiSelectionEnabled(true);
        this.m_FileChooserFlow = new FlowFileChooser(FlowPanel.getProperties().getPath("InitialDir", "%h"));
        this.m_FileChooserFlow.setMultiSelectionEnabled(false);
        this.m_LastObjectLocatorOriginal = new PassThrough();
        this.m_LastObjectLocatorProcessed = new PassThrough();
        this.m_LastImageOverlayOriginal = new NullOverlay();
        this.m_LastImageOverlayProcessed = new NullOverlay();
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_SplitPane = new BaseSplitPane(1);
        this.m_SplitPane.setResizeWeight(1.0);
        this.add((Component)this.m_SplitPane, "Center");
        this.m_TabbedPane = new ImageProcessorTabbedPane(this);
        this.m_TabbedPane.setCloseTabsWithMiddleMouseButton(true);
        this.m_TabbedPane.addChangeListener(e -> this.update());
        this.m_SplitPane.setLeftComponent((Component)((Object)this.m_TabbedPane));
        this.m_PanelFlow = new FlowPanel();
        this.m_PanelFlow.getTitleGenerator().setEnabled(false);
        this.m_PanelFlow.setMinimumSize(new Dimension(400, 0));
        this.m_PanelFlow.getUndo().clear();
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.m_PanelFlow, "Center");
        JPanel panelBottom = new JPanel(new BorderLayout());
        panel.add((Component)panelBottom, "South");
        JPanel panelStatus = new JPanel(new FlowLayout(0));
        panelBottom.add((Component)panelStatus, "West");
        JPanel panelButtons = new JPanel(new FlowLayout(2));
        panelBottom.add((Component)panelButtons, "East");
        this.m_LabelProgress = new JLabel();
        panelStatus.add(this.m_LabelProgress);
        this.m_ButtonNew = new JButton(GUIHelper.getIcon((String)"new.gif"));
        this.m_ButtonNew.addActionListener(e -> this.newFlow());
        panelButtons.add(this.m_ButtonNew);
        this.m_ButtonLoad = new JButton(GUIHelper.getIcon((String)"open.gif"));
        this.m_ButtonLoad.addActionListener(e -> this.loadFlow());
        panelButtons.add(this.m_ButtonLoad);
        this.m_ButtonSave = new JButton(GUIHelper.getIcon((String)"save.gif"));
        this.m_ButtonSave.addActionListener(e -> this.saveFlow());
        panelButtons.add(this.m_ButtonSave);
        this.m_ButtonCheck = new JButton(GUIHelper.getIcon((String)"validate.png"));
        this.m_ButtonCheck.addActionListener(e -> this.checkFlow(false));
        panelButtons.add(this.m_ButtonCheck);
        this.m_ButtonRun = new JButton(GUIHelper.getIcon((String)"run.gif"));
        this.m_ButtonRun.addActionListener(e -> this.runFlow());
        panelButtons.add(this.m_ButtonRun);
        this.m_SplitPane.setRightComponent((Component)panel);
    }

    protected void finishInit() {
        super.finishInit();
        this.newFlow();
    }

    protected void update() {
        this.updateTitle();
        this.updateMenu();
    }

    public TitleGenerator getTitleGenerator() {
        return this.m_TitleGenerator;
    }

    protected void updateTitle() {
        if (!this.m_TitleGenerator.isEnabled()) {
            return;
        }
        this.setParentTitle(this.m_TitleGenerator.generate(this.getCurrentFile()));
    }

    public File getCurrentFile() {
        return this.m_TabbedPane.getCurrentFile();
    }

    public File getFileAt(int index) {
        return this.m_TabbedPane.getFileAt(index);
    }

    protected void updateMenu() {
        if (this.m_MenuBar == null) {
            return;
        }
        ImageProcessorSubPanel panel = this.getCurrentPanel();
        boolean hasPanel = panel != null;
        this.m_MenuItemFileLoadRecent.setEnabled(this.m_RecentFilesHandler.size() > 0);
        this.m_MenuItemFileClose.setEnabled(hasPanel);
        if (this.getUndo().canUndo()) {
            this.m_MenuItemEditUndo.setEnabled(true);
            this.m_MenuItemEditUndo.setText("Undo - " + this.getUndo().peekUndoComment());
        } else {
            this.m_MenuItemEditUndo.setEnabled(false);
            this.m_MenuItemEditUndo.setText("Undo");
        }
        if (this.getUndo().canRedo()) {
            this.m_MenuItemEditRedo.setEnabled(true);
            this.m_MenuItemEditRedo.setText("Redo - " + this.getUndo().peekRedoComment());
        } else {
            this.m_MenuItemEditRedo.setEnabled(false);
            this.m_MenuItemEditRedo.setText("Redo");
        }
        this.m_MenuItemViewHorizontal.setEnabled(hasPanel);
        this.m_MenuItemViewVertical.setEnabled(hasPanel);
        this.m_MenuViewLocateObjects.setEnabled(hasPanel);
        this.m_MenuViewRemoveOverlays.setEnabled(hasPanel);
    }

    public JMenuBar getMenuBar() {
        JMenuBar result;
        if (this.m_MenuBar == null) {
            int fZoom;
            int i;
            result = new JMenuBar();
            JMenu menu = new JMenu("File");
            result.add(menu);
            menu.setMnemonic('F');
            menu.addChangeListener(e -> this.updateMenu());
            JMenuItem menuitem = new JMenuItem("Open...");
            menu.add(menuitem);
            menuitem.setMnemonic('O');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed O"));
            menuitem.setIcon(GUIHelper.getIcon((String)"open.gif"));
            menuitem.addActionListener(e -> this.open());
            this.m_MenuItemFileOpen = menuitem;
            JMenu submenu = new JMenu("Open recent");
            menu.add(submenu);
            this.m_RecentFilesHandler = new RecentFilesHandlerWithCommandline(SESSION_FILE, 5, (Object)submenu);
            this.m_RecentFilesHandler.addRecentItemListener((RecentItemListener)new RecentItemListener<JMenu, RecentFilesHandlerWithCommandline.Setup>(){

                public void recentItemAdded(RecentItemEvent<JMenu, RecentFilesHandlerWithCommandline.Setup> e) {
                }

                public void recentItemSelected(RecentItemEvent<JMenu, RecentFilesHandlerWithCommandline.Setup> e) {
                    ImageProcessorPanel.this.load(((RecentFilesHandlerWithCommandline.Setup)e.getItem()).getFile(), (AbstractImageReader)((RecentFilesHandlerWithCommandline.Setup)e.getItem()).getHandler());
                }
            });
            this.m_MenuItemFileLoadRecent = submenu;
            menuitem = new JMenuItem("Close tab");
            menu.add(menuitem);
            menuitem.setMnemonic('t');
            menuitem.setIcon(GUIHelper.getIcon((String)"close_tab_focused.gif"));
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed W"));
            menuitem.addActionListener(e -> this.close());
            this.m_MenuItemFileClose = menuitem;
            menuitem = new JMenuItem("Close");
            menu.addSeparator();
            menu.add(menuitem);
            menuitem.setMnemonic('C');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed Q"));
            menuitem.setIcon(GUIHelper.getIcon((String)"exit.png"));
            menuitem.addActionListener(e -> this.exit());
            menu = new JMenu("Edit");
            result.add(menu);
            menu.setMnemonic('E');
            menu.addChangeListener(e -> this.updateMenu());
            menuitem = new JMenuItem("Undo");
            menu.add(menuitem);
            menuitem.setMnemonic('U');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed Z"));
            menuitem.setIcon(GUIHelper.getIcon((String)"undo.gif"));
            menuitem.addActionListener(e -> this.undo());
            this.m_MenuItemEditUndo = menuitem;
            menuitem = new JMenuItem("Redo");
            menu.add(menuitem);
            menuitem.setMnemonic('R');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed Y"));
            menuitem.setIcon(GUIHelper.getIcon((String)"redo.gif"));
            menuitem.addActionListener(e -> this.redo());
            this.m_MenuItemEditRedo = menuitem;
            menu = new JMenu("View");
            result.add(menu);
            menu.setMnemonic('V');
            menu.addChangeListener(e -> this.updateMenu());
            ButtonGroup group = new ButtonGroup();
            menuitem = new JRadioButtonMenuItem("Horizontal");
            menu.add(menuitem);
            menuitem.setMnemonic('H');
            menuitem.setSelected(false);
            menuitem.setIcon(GUIHelper.getIcon((String)"ip_layout_horizontal.png"));
            menuitem.addActionListener(e -> {
                for (ImageProcessorSubPanel panel : this.getAllPanels()) {
                    panel.setLayoutType(ImageProcessorSubPanel.LayoutType.HORIZONTAL);
                }
                this.updateMenu();
            });
            group.add(menuitem);
            this.m_MenuItemViewHorizontal = menuitem;
            menuitem = new JRadioButtonMenuItem("Vertical");
            menu.add(menuitem);
            menuitem.setMnemonic('V');
            menuitem.setSelected(true);
            menuitem.setIcon(GUIHelper.getIcon((String)"ip_layout_vertical.png"));
            menuitem.addActionListener(e -> {
                for (ImageProcessorSubPanel panel : this.getAllPanels()) {
                    panel.setLayoutType(ImageProcessorSubPanel.LayoutType.VERTICAL);
                }
                this.updateMenu();
            });
            group.add(menuitem);
            this.m_MenuItemViewVertical = menuitem;
            menu.addSeparator();
            submenu = new JMenu("Add overlay");
            menu.add(submenu);
            submenu.setMnemonic('A');
            submenu.setIcon(GUIHelper.getIcon((String)"add.gif"));
            this.m_MenuViewRemoveOverlays = submenu;
            menuitem = new JMenuItem("Original");
            submenu.add(menuitem);
            menuitem.setMnemonic('O');
            menuitem.addActionListener(e -> {
                ImageOverlay overlay = this.selectImageOverlay(this.m_LastImageOverlayOriginal);
                for (ImageProcessorSubPanel panel : this.getAllPanels()) {
                    panel.addImageOverlay(true, overlay);
                }
            });
            menuitem = new JMenuItem("Processed");
            submenu.add(menuitem);
            menuitem.setMnemonic('P');
            menuitem.addActionListener(e -> {
                ImageOverlay overlay = this.selectImageOverlay(this.m_LastImageOverlayOriginal);
                for (ImageProcessorSubPanel panel : this.getAllPanels()) {
                    panel.addImageOverlay(false, overlay);
                }
            });
            submenu = new JMenu("Remove overlays");
            menu.add(submenu);
            submenu.setMnemonic('R');
            submenu.setIcon(GUIHelper.getIcon((String)"remove.gif"));
            this.m_MenuViewRemoveOverlays = submenu;
            menuitem = new JMenuItem("Original");
            submenu.add(menuitem);
            menuitem.setMnemonic('O');
            menuitem.addActionListener(e -> {
                for (ImageProcessorSubPanel panel : this.getAllPanels()) {
                    panel.clearImageOverlays(true);
                }
            });
            menuitem = new JMenuItem("Processed");
            submenu.add(menuitem);
            menuitem.setMnemonic('P');
            menuitem.addActionListener(e -> {
                for (ImageProcessorSubPanel panel : this.getAllPanels()) {
                    panel.clearImageOverlays(false);
                }
            });
            submenu = new JMenu("Locate objects");
            menu.add(submenu);
            submenu.setMnemonic('L');
            submenu.setIcon(GUIHelper.getIcon((String)"locateobjects.gif"));
            this.m_MenuViewLocateObjects = submenu;
            menuitem = new JMenuItem("Original");
            submenu.add(menuitem);
            menuitem.setMnemonic('O');
            menuitem.addActionListener(e -> {
                AbstractObjectLocator loc = this.selectObjectLocator(this.m_LastObjectLocatorOriginal);
                if (loc == null) {
                    return;
                }
                this.m_LastObjectLocatorOriginal = loc;
                for (ImageProcessorSubPanel panel : this.getAllPanels()) {
                    panel.locateObjects(true, loc);
                }
            });
            menuitem = new JMenuItem("Processed");
            submenu.add(menuitem);
            menuitem.setMnemonic('P');
            menuitem.addActionListener(e -> {
                AbstractObjectLocator loc = this.selectObjectLocator(this.m_LastObjectLocatorOriginal);
                if (loc == null) {
                    return;
                }
                this.m_LastObjectLocatorOriginal = loc;
                for (ImageProcessorSubPanel panel : this.getAllPanels()) {
                    panel.locateObjects(false, loc);
                }
            });
            submenu = new JMenu("Zoom");
            menu.add(submenu);
            submenu.setIcon(GUIHelper.getIcon((String)"glasses.gif"));
            JMenu subsubmenu = new JMenu("Original");
            submenu.add(subsubmenu);
            int[] zooms = new int[]{-100, 25, 50, 66, 75, 100, 150, 200, 400, 800};
            for (i = 0; i < zooms.length; ++i) {
                fZoom = zooms[i];
                menuitem = zooms[i] == -100 ? new JMenuItem("Best fit") : new JMenuItem(zooms[i] + "%");
                subsubmenu.add(menuitem);
                menuitem.addActionListener(ae -> this.setScale((double)fZoom / 100.0, true));
            }
            subsubmenu = new JMenu("Processed");
            submenu.add(subsubmenu);
            zooms = new int[]{-100, 25, 50, 66, 75, 100, 150, 200, 400, 800};
            for (i = 0; i < zooms.length; ++i) {
                fZoom = zooms[i];
                menuitem = zooms[i] == -100 ? new JMenuItem("Best fit") : new JMenuItem(zooms[i] + "%");
                subsubmenu.add(menuitem);
                menuitem.addActionListener(ae -> this.setScale((double)fZoom / 100.0, false));
            }
            this.m_MenuBar = result;
            this.updateMenu();
        } else {
            result = this.m_MenuBar;
        }
        return result;
    }

    public ImageProcessorSubPanel getCurrentPanel() {
        return this.m_TabbedPane.getCurrentPanel();
    }

    public ImageProcessorSubPanel getPanelAt(int index) {
        return this.m_TabbedPane.getPanelAt(index);
    }

    public ImageProcessorSubPanel[] getAllPanels() {
        return this.m_TabbedPane.getAllPanels();
    }

    protected void open() {
        File[] files;
        int retVal = this.m_FileChooserImage.showOpenDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        for (File file : files = this.m_FileChooserImage.getSelectedFiles()) {
            this.load(file, this.m_FileChooserImage.getImageReader());
        }
    }

    public void load(File file) {
        this.load(file, this.m_FileChooserImage.getReaderForFile(file));
    }

    public void load(File file, AbstractImageReader reader) {
        if (this.m_TabbedPane.load(file, reader) && this.m_RecentFilesHandler != null) {
            this.m_RecentFilesHandler.addRecentItem((Object)new RecentFilesHandlerWithCommandline.Setup(file, (Object)reader));
        }
        this.update();
    }

    protected void close() {
        int index = this.m_TabbedPane.getSelectedIndex();
        ImageProcessorSubPanel panel = this.getPanelAt(index);
        panel.cleanUp();
        this.m_TabbedPane.remove(index);
        this.update();
    }

    protected void exit() {
        int i = 0;
        while (i < this.m_TabbedPane.getTabCount()) {
            this.m_TabbedPane.remove(i);
        }
        if (this.getParentFrame() != null) {
            this.getParentFrame().setVisible(false);
            this.getParentFrame().dispose();
        } else if (this.getParentDialog() != null) {
            this.getParentDialog().setVisible(false);
            this.getParentDialog().dispose();
        }
    }

    public Undo getUndo() {
        return this.getFlow().getUndo();
    }

    public boolean isUndoSupported() {
        return this.getFlow().isUndoSupported();
    }

    public void undo() {
        this.getFlow().undo();
    }

    public void redo() {
        this.getFlow().redo();
    }

    public FlowPanel getFlow() {
        return this.m_PanelFlow;
    }

    protected void newFlow() {
        this.m_PanelFlow.setCurrentFlow((Actor)new SubProcess());
    }

    protected void loadFlow() {
        int retVal = this.m_FileChooserFlow.showOpenDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        FlowReader reader = (FlowReader)this.m_FileChooserFlow.getReader();
        Actor actor = reader.readActor(this.m_FileChooserFlow.getSelectedFile());
        if (actor instanceof SubProcess) {
            this.m_PanelFlow.setCurrentFlow(actor);
        } else {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("The outermost actor in the flow must a " + SubProcess.class.getName() + ", encountered: " + actor.getClass().getName()));
        }
    }

    protected void saveFlow() {
        int retVal = this.m_FileChooserFlow.showSaveDialog((Component)((Object)this));
        if (retVal != 0) {
            return;
        }
        FlowWriter writer = (FlowWriter)this.m_FileChooserFlow.getWriter();
        if (!writer.write(this.m_PanelFlow.getCurrentFlow(), this.m_FileChooserFlow.getSelectedFile())) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to write flow snippet to: " + this.m_FileChooserFlow.getSelectedFile()));
        }
    }

    protected boolean checkFlow(boolean silent) {
        String msg = null;
        Actor actor = this.m_PanelFlow.getCurrentFlow();
        SubProcess sub = null;
        if (!(actor instanceof SubProcess)) {
            msg = "Outermost actor must be a " + SubProcess.class.getName() + ", found: " + actor.getClass().getName();
        } else {
            sub = (SubProcess)actor;
        }
        if (msg == null) {
            Compatibility comp = new Compatibility();
            if (!comp.isCompatible(new Class[]{AbstractImageContainer.class}, sub.accepts())) {
                msg = "Flow snippet does not accept " + AbstractImageContainer.class.getClass() + ", found: " + Utils.classesToString((Class[])sub.accepts());
            } else if (!comp.isCompatible(sub.generates(), new Class[]{AbstractImageContainer.class})) {
                msg = "Flow snippet does not generate " + AbstractImageContainer.class.getClass() + ", found: " + Utils.classesToString((Class[])sub.generates());
            }
        }
        if (msg != null) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Flow failed test:\n" + msg));
        } else if (!silent) {
            GUIHelper.showInformationMessage((Component)((Object)this), (String)"Flow passed test!");
        }
        return msg == null;
    }

    protected void runFlow() {
        if (!this.checkFlow(true)) {
            return;
        }
        SwingWorker worker = new SwingWorker(){
            protected MessageCollection m_Errors;

            protected Object doInBackground() throws Exception {
                this.m_Errors = new MessageCollection();
                ImageProcessorPanel.this.m_ButtonCheck.setEnabled(false);
                ImageProcessorPanel.this.m_ButtonRun.setEnabled(false);
                ImageProcessorSubPanel[] panels = ImageProcessorPanel.this.getAllPanels();
                for (int i = 0; i < panels.length; ++i) {
                    ImageProcessorPanel.this.m_LabelProgress.setText(i + 1 + "/" + panels.length + "...");
                    String msg = panels[i].runFlow();
                    if (msg == null) continue;
                    this.m_Errors.add("\nFile #" + (i + 1) + ": " + panels[i].getCurrentFile().getName() + " encountered the following error:\n" + msg);
                }
                return null;
            }

            @Override
            protected void done() {
                super.done();
                ImageProcessorPanel.this.m_LabelProgress.setText("");
                ImageProcessorPanel.this.m_ButtonCheck.setEnabled(true);
                ImageProcessorPanel.this.m_ButtonRun.setEnabled(true);
                if (!this.m_Errors.isEmpty()) {
                    GUIHelper.showErrorMessage((Component)((Object)ImageProcessorPanel.this), (String)this.m_Errors.toString().trim());
                }
            }
        };
        worker.execute();
    }

    public ImageOverlay selectImageOverlay(ImageOverlay last) {
        ImageOverlay result = null;
        GenericObjectEditorDialog dialog = this.getParentDialog() != null ? new GenericObjectEditorDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(this.getParentFrame(), true);
        dialog.setTitle("Image overlay");
        dialog.getGOEEditor().setCanChangeClassInDialog(true);
        dialog.getGOEEditor().setClassType(ImageOverlay.class);
        dialog.setCurrent((Object)last);
        dialog.pack();
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
        if (dialog.getResult() == 0) {
            result = (ImageOverlay)dialog.getCurrent();
        }
        dialog.dispose();
        return result;
    }

    public AbstractObjectLocator selectObjectLocator(AbstractObjectLocator last) {
        AbstractObjectLocator result = null;
        GenericObjectEditorDialog dialog = this.getParentDialog() != null ? new GenericObjectEditorDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(this.getParentFrame(), true);
        dialog.setTitle("Locate objects");
        dialog.getGOEEditor().setCanChangeClassInDialog(true);
        dialog.getGOEEditor().setClassType(AbstractObjectLocator.class);
        dialog.setCurrent((Object)last);
        dialog.pack();
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
        if (dialog.getResult() == 0) {
            result = (AbstractObjectLocator)((Object)dialog.getCurrent());
        }
        dialog.dispose();
        return result;
    }

    public void setScale(double value, boolean original) {
        for (ImageProcessorSubPanel panel : this.getAllPanels()) {
            panel.setScale(original, value);
        }
    }

    public void cleanUp() {
        this.m_TabbedPane.cleanUp();
        this.m_PanelFlow.cleanUp();
    }
}

