/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.core.CleanUpHandler;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.io.input.AbstractImageReader;
import adams.flow.control.SubProcess;
import adams.flow.core.Token;
import adams.flow.transformer.locateobjects.AbstractObjectLocator;
import adams.flow.transformer.locateobjects.LocatedObjects;
import adams.gui.core.BasePanel;
import adams.gui.core.BasePopupMenu;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.CustomPopupMenuProvider;
import adams.gui.core.GUIHelper;
import adams.gui.flow.FlowPanel;
import adams.gui.tools.ImageProcessorTabbedPane;
import adams.gui.visualization.image.ImageOverlay;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.ObjectLocationsOverlayFromReport;
import com.github.fracpete.jclipboardhelper.ClipboardHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Iterator;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class ImageProcessorSubPanel
extends BasePanel
implements CleanUpHandler {
    private static final long serialVersionUID = -5617124372054881553L;
    protected ImageProcessorTabbedPane m_Owner;
    protected LayoutType m_LayoutType;
    protected ImagePanel m_PanelOriginal;
    protected ImagePanel m_PanelProcessed;
    protected BaseSplitPane m_SplitImages;

    public ImageProcessorSubPanel(ImageProcessorTabbedPane owner) {
        this(owner, LayoutType.VERTICAL);
    }

    public ImageProcessorSubPanel(ImageProcessorTabbedPane owner, LayoutType layout) {
        this.m_Owner = owner;
        this.setLayoutType(layout);
    }

    protected void initialize() {
        super.initialize();
        this.m_LayoutType = LayoutType.VERTICAL;
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_PanelOriginal = new ImagePanel();
        this.m_PanelOriginal.setShowProperties(false);
        this.m_PanelOriginal.setShowLog(false);
        ImagePopupMenuProvider popup = new ImagePopupMenuProvider(this.m_PanelOriginal);
        this.m_PanelOriginal.setCustomPopupMenuProvider((CustomPopupMenuProvider)popup);
        this.m_PanelProcessed = new ImagePanel();
        this.m_PanelProcessed.setShowProperties(false);
        this.m_PanelProcessed.setShowLog(false);
        popup = new ImagePopupMenuProvider(this.m_PanelProcessed);
        this.m_PanelProcessed.setCustomPopupMenuProvider((CustomPopupMenuProvider)popup);
        this.m_SplitImages = new BaseSplitPane(1);
        this.m_SplitImages.setResizeWeight(0.5);
        this.m_SplitImages.setTopComponent((Component)this.m_PanelOriginal);
        this.m_SplitImages.setBottomComponent((Component)this.m_PanelProcessed);
        this.add((Component)this.m_SplitImages, "Center");
    }

    protected void updateLayout() {
        switch (this.m_LayoutType) {
            case HORIZONTAL: {
                this.m_SplitImages.setOrientation(1);
                break;
            }
            case VERTICAL: {
                this.m_SplitImages.setOrientation(0);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled layout type: " + (Object)((Object)this.m_LayoutType));
            }
        }
    }

    public void setLayoutType(LayoutType value) {
        this.m_LayoutType = value;
        this.updateLayout();
    }

    public LayoutType getLayoutType() {
        return this.m_LayoutType;
    }

    public ImagePanel getOriginal() {
        return this.m_PanelOriginal;
    }

    public ImagePanel getProcessed() {
        return this.m_PanelProcessed;
    }

    public boolean load(File file) {
        return this.load(file, null);
    }

    public boolean load(File file, AbstractImageReader reader) {
        boolean result = this.m_PanelOriginal.load(file, reader);
        if (result) {
            this.m_PanelProcessed.setCurrentImage(this.m_PanelOriginal.getCurrentImage());
        }
        return result;
    }

    public File getCurrentFile() {
        return this.m_PanelOriginal.getCurrentFile();
    }

    public FlowPanel getFlowPanel() {
        return this.m_Owner.m_Owner.getFlow();
    }

    public String runFlow() {
        String result = null;
        BufferedImageContainer contIn = new BufferedImageContainer();
        contIn.setImage((Object)this.m_PanelOriginal.getCurrentImage());
        AbstractImageContainer contOut = null;
        SubProcess sub = (SubProcess)this.getFlowPanel().getCurrentFlow();
        String msg = sub.setUp();
        if (msg == null) {
            sub.input(new Token((Object)contIn));
            msg = sub.execute();
        }
        if (msg == null) {
            if (sub.hasPendingOutput()) {
                contOut = (AbstractImageContainer)sub.output().getPayload();
            } else {
                msg = "No output produced?";
            }
        }
        sub.cleanUp();
        sub.destroy();
        if (contOut != null) {
            this.m_PanelProcessed.setCurrentImage(contOut.toBufferedImage(), this.m_PanelProcessed.getScale());
        } else if (msg != null) {
            result = "Flow execution failed:\n" + msg;
        }
        return result;
    }

    public void addImageOverlay(boolean original, ImageOverlay overlay) {
        if (original) {
            this.m_PanelOriginal.addImageOverlay(overlay);
        } else {
            this.m_PanelProcessed.addImageOverlay(overlay);
        }
    }

    public void clearImageOverlays(boolean original) {
        if (original) {
            this.m_PanelOriginal.clearImageOverlays();
        } else {
            this.m_PanelProcessed.clearImageOverlays();
        }
    }

    public Iterator<ImageOverlay> imageOverlays(boolean original) {
        if (original) {
            return this.m_PanelOriginal.imageOverlays();
        }
        return this.m_PanelProcessed.imageOverlays();
    }

    public void locateObjects(boolean original, AbstractObjectLocator locator) {
        this.clearImageOverlays(original);
        ObjectLocationsOverlayFromReport overlay = new ObjectLocationsOverlayFromReport();
        if (original) {
            this.m_PanelOriginal.addImageOverlay((ImageOverlay)overlay);
            LocatedObjects located = locator.locate(this.m_PanelOriginal.getCurrentImage());
            this.m_PanelOriginal.setAdditionalProperties(located.toReport(overlay.getPrefix()));
        } else {
            this.m_PanelProcessed.addImageOverlay((ImageOverlay)overlay);
            LocatedObjects located = locator.locate(this.m_PanelProcessed.getCurrentImage());
            this.m_PanelProcessed.setAdditionalProperties(located.toReport(overlay.getPrefix()));
        }
    }

    public void setScale(boolean original, double value) {
        if (original) {
            this.m_PanelOriginal.setScale(value);
        } else {
            this.m_PanelProcessed.setScale(value);
        }
    }

    public void cleanUp() {
        this.m_PanelOriginal.cleanUp();
        this.m_PanelProcessed.cleanUp();
    }

    public static class ImagePopupMenuProvider
    implements CustomPopupMenuProvider {
        protected ImagePanel m_Panel;

        public ImagePopupMenuProvider(ImagePanel panel) {
            if (panel == null) {
                throw new IllegalArgumentException("ImagePanel instance cannot be null!");
            }
            this.m_Panel = panel;
        }

        public ImagePanel getPanel() {
            return this.m_Panel;
        }

        public BasePopupMenu getCustomPopupMenu(MouseEvent e) {
            BasePopupMenu menu = new BasePopupMenu();
            JMenuItem menuitem = new JMenuItem("Copy", GUIHelper.getIcon((String)"copy.gif"));
            menuitem.setEnabled(this.getPanel().getCurrentImage() != null);
            menuitem.addActionListener(ae -> ClipboardHelper.copyToClipboard((BufferedImage)this.getPanel().getCurrentImage()));
            menu.add(menuitem);
            menuitem = new JMenuItem("Export...", GUIHelper.getIcon((String)"save.gif"));
            menuitem.setEnabled(this.getPanel().getCurrentImage() != null);
            menuitem.addActionListener(ae -> this.getPanel().export());
            menu.add(menuitem);
            menuitem = new JMenuItem("Save report...", GUIHelper.getEmptyIcon());
            menuitem.setEnabled(this.getPanel().getCurrentImage() != null);
            menuitem.addActionListener(ae -> this.getPanel().saveReport());
            menu.add(menuitem);
            menu.addSeparator();
            JMenu submenu = new JMenu("Zoom");
            menu.add((JMenuItem)submenu);
            submenu.setIcon(GUIHelper.getIcon((String)"glasses.gif"));
            menuitem = new JMenuItem("Zoom in");
            submenu.add(menuitem);
            menuitem.addActionListener(ae -> this.m_Panel.setScale(this.m_Panel.getActualScale() * 1.5));
            menuitem = new JMenuItem("Zoom out");
            submenu.add(menuitem);
            menuitem.addActionListener(ae -> this.m_Panel.setScale(this.m_Panel.getActualScale() / 1.5));
            int[] zooms = new int[]{-100, 25, 50, 66, 75, 100, 150, 200, 400, 800};
            submenu.addSeparator();
            for (int i = 0; i < zooms.length; ++i) {
                int fZoom = zooms[i];
                menuitem = zooms[i] == -100 ? new JMenuItem("Best fit") : new JMenuItem(zooms[i] + "%");
                submenu.add(menuitem);
                menuitem.addActionListener(ae -> this.m_Panel.setScale((double)fZoom / 100.0));
            }
            return menu;
        }
    }

    public static enum LayoutType {
        HORIZONTAL,
        VERTICAL;

    }
}

