/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.data.io.input.AbstractImageReader;
import adams.data.io.input.DefaultSimpleReportReader;
import adams.data.io.input.JAIImageReader;
import adams.data.report.Report;
import adams.gui.core.ColorHelper;
import adams.gui.tools.previewbrowser.AbstractContentHandler;
import adams.gui.tools.previewbrowser.PreviewPanel;
import adams.gui.visualization.image.ImageOverlay;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.MultiImageOverlay;
import adams.gui.visualization.image.ObjectLocationsOverlayFromReport;
import java.awt.Color;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;

public class AnnotationsAndPredictionsFromReport
extends AbstractContentHandler {
    private static final long serialVersionUID = -3962259305718630395L;
    public static final String PREFIX_ANNOTATIONS = "Object.";
    public static final String PREFIX_PREDICTIONS = "Prediction.";
    public static final Color COLOR_ANNOTATIONS = Color.RED;
    public static final Color COLOR_PREDICTIONS = Color.GREEN;

    public String globalInfo() {
        return "Displays the following image types with an overlay for the annotations and predictions stored in the report with the same name: " + Utils.arrayToString((Object)this.getExtensions()) + "\nAnnotations have to have the prefix '" + PREFIX_ANNOTATIONS + "' and predictions '" + PREFIX_PREDICTIONS + "'.\nThe color for annotations is " + this.toString(COLOR_ANNOTATIONS) + " and for predictions " + this.toString(COLOR_PREDICTIONS) + ".";
    }

    protected String toString(Color color) {
        if (ColorHelper.toName((Color)color) == null) {
            return ColorHelper.toHex((Color)color);
        }
        return ColorHelper.toName((Color)color);
    }

    public String[] getExtensions() {
        return new JAIImageReader().getFormatExtensions();
    }

    protected PreviewPanel createPreview(File file) {
        ImagePanel panel = new ImagePanel();
        MultiImageOverlay multi = null;
        Report report = null;
        File reportFile = FileUtils.replaceExtension((File)file, (String)".report");
        if (reportFile.exists() && reportFile.isFile()) {
            DefaultSimpleReportReader reportReader = new DefaultSimpleReportReader();
            reportReader.setInput(new PlaceholderFile(reportFile));
            List reports = reportReader.read();
            if (reports.size() > 0) {
                report = (Report)reports.get(0);
                ObjectLocationsOverlayFromReport annotations = new ObjectLocationsOverlayFromReport();
                annotations.setTypeSuffix(".type");
                annotations.setLabelFormat("#. $");
                annotations.setPrefix(PREFIX_ANNOTATIONS);
                annotations.setColor(COLOR_ANNOTATIONS);
                ObjectLocationsOverlayFromReport predictions = new ObjectLocationsOverlayFromReport();
                predictions.setTypeSuffix(".type");
                predictions.setLabelFormat("#. $");
                predictions.setPrefix(PREFIX_PREDICTIONS);
                predictions.setColor(COLOR_PREDICTIONS);
                multi = new MultiImageOverlay();
                multi.setOverlays(new ImageOverlay[]{annotations, predictions});
            }
        }
        if (multi != null) {
            panel.addImageOverlay(multi);
            panel.setAdditionalProperties(report);
        }
        panel.load(file, (AbstractImageReader)new JAIImageReader(), -1.0);
        return new PreviewPanel((JComponent)panel, (JComponent)panel.getPaintPanel());
    }
}

