/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.data.io.input.AbstractImageReader;
import adams.data.io.input.DefaultSimpleReportReader;
import adams.data.io.input.JAIImageReader;
import adams.data.report.Report;
import adams.gui.tools.previewbrowser.AbstractContentHandler;
import adams.gui.tools.previewbrowser.PreviewPanel;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.ObjectCentersOverlayFromReport;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;

public class ObjectCentersFromReport
extends AbstractContentHandler {
    private static final long serialVersionUID = -3962259305718630395L;

    public String globalInfo() {
        return "Displays the following image types with an overlay for the objects stored in the report with the same name (using object prefix 'Object.'): " + Utils.arrayToString((Object)this.getExtensions());
    }

    public String[] getExtensions() {
        return new JAIImageReader().getFormatExtensions();
    }

    protected PreviewPanel createPreview(File file) {
        ImagePanel panel = new ImagePanel();
        ObjectCentersOverlayFromReport overlay = null;
        Report report = null;
        File reportFile = FileUtils.replaceExtension((File)file, (String)".report");
        if (reportFile.exists() && reportFile.isFile()) {
            DefaultSimpleReportReader reportReader = new DefaultSimpleReportReader();
            reportReader.setInput(new PlaceholderFile(reportFile));
            List reports = reportReader.read();
            if (reports.size() > 0) {
                report = (Report)reports.get(0);
                overlay = new ObjectCentersOverlayFromReport();
                overlay.setUseColorsPerType(true);
                overlay.setTypeSuffix(".type");
                overlay.setLabelFormat("#. $");
                overlay.setPrefix("Object.");
            }
        }
        if (overlay != null) {
            panel.addImageOverlay(overlay);
            panel.setAdditionalProperties(report);
        }
        panel.load(file, (AbstractImageReader)new JAIImageReader(), -1.0);
        return new PreviewPanel((JComponent)panel, (JComponent)panel.getPaintPanel());
    }
}

