/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image;

import adams.data.container.DataPoint;
import adams.data.image.BufferedImageHelper;
import adams.flow.sink.sequenceplotter.SequencePlotPoint;
import adams.flow.sink.sequenceplotter.SequencePlotSequence;
import adams.flow.sink.sequenceplotter.SequencePlotterPanel;
import adams.gui.visualization.core.AbstractHistogramPanel;
import adams.gui.visualization.core.Paintlet;
import adams.gui.visualization.sequence.StickPaintlet;
import java.awt.image.BufferedImage;

public class HistogramPanel
extends AbstractHistogramPanel<BufferedImage> {
    private static final long serialVersionUID = -8621818594275641231L;

    protected SequencePlotterPanel newPanel(String name) {
        SequencePlotterPanel result = super.newPanel(name);
        StickPaintlet paintlet = new StickPaintlet();
        result.setDataPaintlet((Paintlet)paintlet);
        return result;
    }

    protected SequencePlotSequence[] createSequences() {
        this.removeAll();
        boolean gray = ((BufferedImage)this.m_Data).getType() == 10 || ((BufferedImage)this.m_Data).getType() == 12;
        SequencePlotSequence[] result = gray ? new SequencePlotSequence[1] : new SequencePlotSequence[3];
        int[][] histogram = BufferedImageHelper.histogram((BufferedImage)((BufferedImage)this.m_Data), (boolean)gray);
        for (int i = 0; i < histogram.length; ++i) {
            String name;
            switch (i) {
                case 0: {
                    if (gray) {
                        name = "Gray";
                        break;
                    }
                    name = "Red";
                    break;
                }
                case 1: {
                    name = "Green";
                    break;
                }
                case 2: {
                    name = "Blue";
                    break;
                }
                default: {
                    name = null;
                }
            }
            if (name == null) continue;
            result[i] = new SequencePlotSequence();
            result[i].setID(name);
            for (int n = 0; n < histogram[i].length; ++n) {
                result[i].add((DataPoint)new SequencePlotPoint((double)n, (double)histogram[i][n]));
            }
        }
        return result;
    }

    public void setImage(BufferedImage value) {
        this.setData(value);
    }

    public BufferedImage getImage() {
        return (BufferedImage)this.getData();
    }
}

