/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image.leftclick;

import adams.core.Utils;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.SelectionRectangle;
import adams.gui.visualization.image.leftclick.AbstractSelectionRectangleBasedLeftClickProcessor;
import java.awt.Point;
import java.util.ArrayList;

public class FixedBoundingBox
extends AbstractSelectionRectangleBasedLeftClickProcessor {
    private static final long serialVersionUID = 4069769951854697560L;
    protected int m_Width;
    protected int m_Height;

    public String globalInfo() {
        return "Allows the user to create fixed-sized bounding boxes around the left-click position (<ctrl> left-click in box removes it).";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("width", "width", (Object)10, (Number)1, null);
        this.m_OptionManager.add("height", "height", (Object)10, (Number)1, null);
    }

    public void setWidth(int value) {
        this.m_Width = value;
        this.reset();
    }

    public int getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The width of the bounding box.";
    }

    public void setHeight(int value) {
        this.m_Height = value;
        this.reset();
    }

    public int getHeight() {
        return this.m_Height;
    }

    public String heightTipText() {
        return "The height of the bounding box.";
    }

    protected void doProcessClick(ImagePanel panel, Point position, int modifiersEx) {
        Report report = panel.getAdditionalProperties().getClone();
        if (this.m_Locations == null) {
            this.m_Locations = this.getLocations(report);
        }
        int x = panel.mouseToPixelLocation((Point)position).x;
        int y = panel.mouseToPixelLocation((Point)position).y;
        ArrayList<SelectionRectangle> queue = new ArrayList<SelectionRectangle>();
        boolean modified = false;
        if ((modifiersEx & 0x80) != 0) {
            for (SelectionRectangle r : this.m_Locations) {
                if (!r.contains(x, y)) continue;
                modified = true;
                String current = this.m_Prefix + Utils.padLeft((String)("" + r.getIndex()), (char)'0', (int)this.m_NumDigits);
                report.removeValue((AbstractField)new Field(current + ".x", DataType.NUMERIC));
                report.removeValue((AbstractField)new Field(current + ".y", DataType.NUMERIC));
                report.removeValue((AbstractField)new Field(current + ".width", DataType.NUMERIC));
                report.removeValue((AbstractField)new Field(current + ".height", DataType.NUMERIC));
                queue.add(r);
            }
            this.m_Locations.removeAll(queue);
        } else {
            SelectionRectangle rect = new SelectionRectangle(x - this.m_Width / 2, y - this.m_Height / 2, this.m_Width, this.m_Height);
            if (!this.m_Locations.contains(rect)) {
                modified = true;
                int lastIndex = this.findLastIndex(report);
                String current = this.m_Prefix + Utils.padLeft((String)("" + (lastIndex + 1)), (char)'0', (int)this.m_NumDigits);
                report.setNumericValue(current + ".x", rect.getX());
                report.setNumericValue(current + ".y", rect.getY());
                report.setNumericValue(current + ".width", rect.getWidth());
                report.setNumericValue(current + ".height", rect.getHeight());
                this.m_Locations.add(rect);
            }
        }
        if (modified) {
            panel.setAdditionalProperties(report);
        }
    }
}

