/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image.selection;

import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.selection.AbstractSelectionProcessor;
import adams.gui.visualization.image.selection.SelectionProcessor;
import java.awt.Point;

public class MultiSelectionProcessor
extends AbstractSelectionProcessor {
    private static final long serialVersionUID = 6323046923720400796L;
    protected SelectionProcessor[] m_Processors;

    public String globalInfo() {
        return "Applies all the sub-processors sequentially.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("processors", "processors", (Object)new SelectionProcessor[0]);
    }

    public void setProcessors(SelectionProcessor[] value) {
        this.m_Processors = value;
        this.reset();
    }

    public SelectionProcessor[] getProcessors() {
        return this.m_Processors;
    }

    public String processorsTipText() {
        return "The sub-processors to apply sequentially to the selection.";
    }

    protected void doImageChanged(ImagePanel.PaintPanel panel) {
        super.doImageChanged(panel);
        for (SelectionProcessor processor : this.m_Processors) {
            processor.imageChanged(panel);
        }
    }

    protected void doProcessSelection(ImagePanel panel, Point topLeft, Point bottomRight, int modifiersEx) {
        for (SelectionProcessor processor : this.m_Processors) {
            processor.processSelection(panel, topLeft, bottomRight, modifiersEx);
        }
    }
}

