/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.features;

import adams.data.featureconverter.HeaderDefinition;
import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.image.features.AbstractBufferedImageFeatureGenerator;
import adams.data.report.DataType;
import adams.data.statistics.StatUtils;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public class BasicStatistics
extends AbstractBufferedImageFeatureGenerator {
    private static final long serialVersionUID = -8349656592325229512L;

    public String globalInfo() {
        return "Calculates min/max/mean/median/stdev for each channel (R,G,B).";
    }

    @Override
    public HeaderDefinition createHeader(BufferedImageContainer img) {
        HeaderDefinition result = new HeaderDefinition();
        for (String c : new String[]{"R", "G", "B"}) {
            result.add(c + "-min", DataType.NUMERIC);
            result.add(c + "-max", DataType.NUMERIC);
            result.add(c + "-mean", DataType.NUMERIC);
            result.add(c + "-median", DataType.NUMERIC);
            result.add(c + "-stdev", DataType.NUMERIC);
        }
        return result;
    }

    @Override
    public List<Object>[] generateRows(BufferedImageContainer img) {
        int n;
        ArrayList<Double[]> rgb = new ArrayList<Double[]>();
        rgb.add(new Double[img.getHeight() * img.getWidth()]);
        rgb.add(new Double[img.getHeight() * img.getWidth()]);
        rgb.add(new Double[img.getHeight() * img.getWidth()]);
        int[][] p = BufferedImageHelper.getRGBPixels((BufferedImage)((BufferedImage)img.getImage()));
        for (int i = 0; i < p.length; ++i) {
            for (n = 0; n < 3; ++n) {
                ((Double[])rgb.get((int)n))[i] = p[i][n];
            }
        }
        List[] result = new List[]{new ArrayList()};
        for (n = 0; n < 3; ++n) {
            result[0].add(StatUtils.min((Number[])((Number[])rgb.get(n))));
            result[0].add(StatUtils.max((Number[])((Number[])rgb.get(n))));
            result[0].add(StatUtils.mean((Number[])((Number[])rgb.get(n))));
            result[0].add(StatUtils.median((Number[])((Number[])rgb.get(n))));
            result[0].add(StatUtils.stddev((Number[])((Number[])rgb.get(n)), (boolean)true));
        }
        return result;
    }
}

