/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.features;

import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.image.IntArrayMatrixView;
import adams.data.image.features.AbstractCountColor;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public class CountColorOutside
extends AbstractCountColor {
    private static final long serialVersionUID = -8349656592325229512L;

    public String globalInfo() {
        return "Counts the occurrences of a specific color from the outside, going through the image line by line (alpha channel gets ignored).";
    }

    @Override
    public List<Object>[] generateRows(BufferedImageContainer img) {
        BufferedImage image = BufferedImageHelper.convert((BufferedImage)((BufferedImage)img.getImage()), (int)6);
        int count = 0;
        int color = this.m_Color.getRGB() & 0xFFFFFF;
        IntArrayMatrixView view = new IntArrayMatrixView(BufferedImageHelper.getPixels((BufferedImage)image), image.getWidth(), image.getHeight());
        for (int y = 0; y < view.getHeight(); ++y) {
            int x;
            int lastX = -1;
            if ((view.get(0, y) & 0xFFFFFF) == color) {
                x = 0;
                while (x < view.getWidth() && (view.get(x, y) & 0xFFFFFF) == color) {
                    lastX = x++;
                    ++count;
                }
            }
            if (lastX >= view.getWidth() - 1 || (view.get(view.getWidth() - 1, y) & 0xFFFFFF) != color) continue;
            for (x = view.getWidth() - 1; x >= 0 && x > lastX && (view.get(x, y) & 0xFFFFFF) == color; --x) {
                ++count;
            }
        }
        List[] result = new List[]{new ArrayList()};
        if (this.m_UsePercentage) {
            result[0].add((double)count / (double)view.size());
        } else {
            result[0].add(count);
        }
        return result;
    }
}

