/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.features;

import adams.data.featureconverter.HeaderDefinition;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.image.features.AbstractBufferedImageFeatureGenerator;
import adams.data.image.features.Pixels;
import adams.data.image.transformer.AbstractBufferedImageTransformer;
import adams.data.image.transformer.PassThrough;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FilteredBufferedImageFeatureGenerator
extends AbstractBufferedImageFeatureGenerator {
    private static final long serialVersionUID = -8349656592325229512L;
    protected AbstractBufferedImageTransformer m_Filter;
    protected AbstractBufferedImageFeatureGenerator m_Generator;

    public String globalInfo() {
        return "Applies the filter (an image transformer) to the image first before generating the features from the transformed images.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("filter", "filter", (Object)new PassThrough());
        this.m_OptionManager.add("generator", "generator", (Object)new Pixels());
    }

    public void setFilter(AbstractBufferedImageTransformer value) {
        this.m_Filter = value;
        this.reset();
    }

    public AbstractBufferedImageTransformer getFilter() {
        return this.m_Filter;
    }

    public String filterTipText() {
        return "The filter to use.";
    }

    public void setGenerator(AbstractBufferedImageFeatureGenerator value) {
        this.m_Generator = value;
        this.reset();
    }

    public AbstractBufferedImageFeatureGenerator getGenerator() {
        return this.m_Generator;
    }

    public String generatorTipText() {
        return "The generator to use on the filtered data.";
    }

    @Override
    public HeaderDefinition createHeader(BufferedImageContainer img) {
        BufferedImageContainer[] conts = (BufferedImageContainer[])this.m_Filter.transform((AbstractImageContainer)img);
        HeaderDefinition result = this.m_Generator.postProcessHeader(this.m_Generator.createHeader(conts[0]));
        return result;
    }

    @Override
    public List<Object>[] generateRows(BufferedImageContainer img) {
        List[] result;
        BufferedImageContainer[] conts;
        ArrayList<List> rows = new ArrayList<List>();
        for (BufferedImageContainer cont : conts = (BufferedImageContainer[])this.m_Filter.transform((AbstractImageContainer)img)) {
            result = this.m_Generator.postProcessRows(cont, this.m_Generator.generateRows(cont));
            rows.addAll(Arrays.asList(result));
        }
        result = new List[rows.size()];
        for (int i = 0; i < rows.size(); ++i) {
            result[i] = (List)rows.get(i);
        }
        return result;
    }
}

