/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.multiimageoperation;

import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.image.multiimageoperation.AbstractBufferedImageMultiImageOperation;
import java.awt.image.BufferedImage;

public class Diff
extends AbstractBufferedImageMultiImageOperation {
    protected int m_Threshold;

    public int getThreshold() {
        return this.m_Threshold;
    }

    public void setThreshold(int m_Threshold) {
        this.m_Threshold = m_Threshold;
    }

    @Override
    public int minNumImagesRequired() {
        return 2;
    }

    @Override
    public int maxNumImagesRequired() {
        return 2;
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("threshold", "threshold", (Object)0);
    }

    protected void check(BufferedImageContainer[] images) {
        super.check((AbstractImageContainer[])images);
        String msg = this.checkSameDimensions((AbstractImageContainer[])images);
        if (msg != null) {
            throw new IllegalStateException(msg);
        }
    }

    protected BufferedImageContainer[] doProcess(BufferedImageContainer[] images) {
        BufferedImageContainer[] result = new BufferedImageContainer[1];
        BufferedImage output = BufferedImageHelper.deepCopy((BufferedImage)images[0].toBufferedImage());
        int[][] channels = new int[images.length][];
        for (int y = 0; y < images[0].getHeight(); ++y) {
            for (int x = 0; x < images[0].getWidth(); ++x) {
                for (int i = 0; i < images.length; ++i) {
                    channels[i] = BufferedImageHelper.split((int)images[i].toBufferedImage().getRGB(x, y));
                }
                int[] split = this.thresholdEquals(channels);
                output.setRGB(x, y, BufferedImageHelper.combine((int[])split));
            }
        }
        result[0] = new BufferedImageContainer();
        result[0].setReport(images[0].getReport().getClone());
        result[0].getNotes().mergeWith(images[0].getNotes());
        result[0].setImage((Object)output);
        return result;
    }

    private int[] thresholdEquals(int[][] channels) {
        int[] result = new int[4];
        result[3] = channels[0][3];
        for (int i = 0; i < 3; ++i) {
            result[i] = Math.abs(channels[0][i] - channels[1][i]) < this.m_Threshold ? 0 : 255;
        }
        return result;
    }

    public String globalInfo() {
        return "Compares two images and returns a third image with the differences between them";
    }
}

