/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.image.transformer.AbstractBufferedImageTransformer;
import java.awt.image.BufferedImage;

public class Binary
extends AbstractBufferedImageTransformer {
    private static final long serialVersionUID = 2959486760492196174L;
    protected int m_Threshold;

    public String globalInfo() {
        return "Turns an image into a binary image, using a grayscale threshold to determine which pixels are black (below) and which are white (equal to or above).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("threshold", "threshold", (Object)128, (Number)0, (Number)255);
    }

    public void setThreshold(int value) {
        if (value >= 0 && value <= 255) {
            this.m_Threshold = value;
            this.reset();
        } else {
            this.getLogger().severe("Threshold has to be 0 <= x <= 255, provided: " + value);
        }
    }

    public int getThreshold() {
        return this.m_Threshold;
    }

    public String thresholdTipText() {
        return "The threshold that determines whether a grayscale pixel will become black (below) or white (equal to or above).";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"threshold", (Object)this.m_Threshold, (String)"threshold: ");
    }

    protected BufferedImageContainer[] doTransform(BufferedImageContainer img) {
        int width = img.getWidth();
        int height = img.getHeight();
        BufferedImageContainer[] result = new BufferedImageContainer[]{(BufferedImageContainer)img.getHeader()};
        BufferedImage image = BufferedImageHelper.convert((BufferedImage)((BufferedImage)img.getImage()), (int)10);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int[] channels = BufferedImageHelper.split((int)image.getRGB(x, y));
                for (int i = 0; i <= 3; ++i) {
                    channels[i] = channels[i] < this.m_Threshold ? 0 : 255;
                }
                image.setRGB(x, y, BufferedImageHelper.combine((int[])channels));
            }
        }
        result[0].setImage((Object)image);
        return result;
    }
}

