/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.transformer;

import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.image.transformer.AbstractBufferedImageTransformer;
import java.awt.image.BufferedImage;

public class MaxRGB
extends AbstractBufferedImageTransformer {
    protected BufferedImageContainer[] doTransform(BufferedImageContainer img) {
        BufferedImageContainer[] result = new BufferedImageContainer[1];
        BufferedImage image = BufferedImageHelper.deepCopy((BufferedImage)img.toBufferedImage());
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                image.setRGB(x, y, this.calcMax(image.getRGB(x, y)));
            }
        }
        result[0] = new BufferedImageContainer();
        result[0].setImage((Object)image);
        return result;
    }

    private int calcMax(int rgb) {
        int result = 0;
        int[] channels = BufferedImageHelper.split((int)rgb);
        int[] maxedChannels = new int[4];
        int currentMax = channels[0];
        int maxIndex = 0;
        for (int i = 1; i < channels.length - 1; ++i) {
            if (currentMax >= channels[i]) continue;
            maxIndex = i;
            currentMax = channels[i];
        }
        maxedChannels[maxIndex] = 255;
        result = BufferedImageHelper.combine((int[])maxedChannels);
        return result;
    }

    public String globalInfo() {
        return null;
    }
}

