/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image.transformer.subimages;

import adams.core.QuickInfoHelper;
import adams.core.QuickInfoSupporter;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.OptionHandler;
import adams.data.image.BufferedImageContainer;
import adams.data.objectfilter.Translate;
import adams.data.objectfinder.ObjectsInRegion;
import adams.data.report.AbstractField;
import adams.data.report.Report;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import java.awt.Rectangle;
import java.util.List;

public abstract class AbstractSubImagesGenerator
extends AbstractOptionHandler
implements QuickInfoSupporter {
    private static final long serialVersionUID = 2258244755943306047L;
    protected String m_Prefix;
    protected boolean m_Partial;
    protected boolean m_FixInvalid;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("prefix", "prefix", (Object)"Object.");
        this.m_OptionManager.add("partial", "partial", (Object)false);
        this.m_OptionManager.add("fix-invalid", "fixInvalid", (Object)false);
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The report field prefix used in the report.";
    }

    public void setPartial(boolean value) {
        this.m_Partial = value;
        this.reset();
    }

    public boolean getPartial() {
        return this.m_Partial;
    }

    public String partialTipText() {
        return "If enabled, partial hits are included as well.";
    }

    public void setFixInvalid(boolean value) {
        this.m_FixInvalid = value;
        this.reset();
    }

    public boolean getFixInvalid() {
        return this.m_FixInvalid;
    }

    public String fixInvalidTipText() {
        return "If enabled, objects that fall partially outside the image boundaries get fixed (eg when allowing partial hits).";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"prefix", (Object)this.m_Prefix, (String)"prefix: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"partial", (boolean)this.m_Partial, (String)"incl. partial", (String)", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"fixInvalid", (boolean)this.m_FixInvalid, (String)"fix", (String)", ");
        return result;
    }

    protected void check(BufferedImageContainer image) {
        if (image == null) {
            throw new IllegalArgumentException("No image provided!");
        }
    }

    protected Report transferObjects(Report oldReport, int x, int y, int width, int height) {
        return this.transferObjects(oldReport, new Rectangle(x, y, width, height));
    }

    protected Report transferObjects(Report oldReport, Rectangle region) {
        Report result;
        try {
            result = (Report)oldReport.getClass().newInstance();
        }
        catch (Exception e) {
            result = new Report();
        }
        boolean anyObjects = false;
        for (AbstractField field : oldReport.getFields()) {
            if (field.getName().startsWith(this.m_Prefix)) {
                anyObjects = true;
                continue;
            }
            result.addField(field);
            result.setValue(field, oldReport.getValue(field));
        }
        if (anyObjects) {
            LocatedObjects objects = LocatedObjects.fromReport(oldReport, this.m_Prefix);
            ObjectsInRegion finder = new ObjectsInRegion();
            finder.setPrefix(this.m_Prefix);
            finder.setPartial(this.m_Partial);
            finder.setLeft((int)region.getX() + 1);
            finder.setTop((int)region.getY() + 1);
            finder.setWidth((int)region.getWidth());
            finder.setHeight((int)region.getHeight());
            LocatedObjects newObjects = finder.findObjects(objects);
            Translate trans = new Translate();
            trans.setX((int)(-region.getX()));
            trans.setY((int)(-region.getY()));
            newObjects = trans.filter(newObjects);
            if (this.m_FixInvalid) {
                for (LocatedObject obj : newObjects) {
                    obj.makeFit((int)region.getWidth(), (int)region.getHeight());
                }
            }
            result.mergeWith(newObjects.toReport(this.m_Prefix));
        }
        return result;
    }

    protected abstract List<BufferedImageContainer> doProcess(BufferedImageContainer var1);

    public List<BufferedImageContainer> process(BufferedImageContainer image) {
        this.check(image);
        return this.doProcess(image);
    }
}

