/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.data.conversion.XMLToDOM;
import adams.data.io.input.AbstractReportReader;
import adams.data.report.Report;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class VggXmlAnnotationReportReader
extends AbstractReportReader<Report> {
    private static final long serialVersionUID = -4823768127617381877L;
    protected String m_Prefix;

    public String globalInfo() {
        return "Reads XML image annotation files, like used in the pets dataset:\nhttp://www.robots.ox.ac.uk/~vgg/data/pets/";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("prefix", "prefix", (Object)"Object.");
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The report field prefix used in the report.";
    }

    public String getFormatDescription() {
        return "VGG XML Annotation";
    }

    public String[] getFormatExtensions() {
        return new String[]{"xml"};
    }

    protected int determineParentID(Report report) {
        return -1;
    }

    public Report newInstance() {
        return new Report();
    }

    protected List<Report> readData() {
        ArrayList<Report> result = new ArrayList<Report>();
        String xml = Utils.flatten((List)FileUtils.loadFromFile((File)this.m_Input), (String)"\n");
        XMLToDOM conv = new XMLToDOM();
        conv.setInput((Object)xml);
        String msg = conv.convert();
        if (msg == null) {
            Document dom = (Document)conv.getOutput();
            NodeList objects = dom.getElementsByTagName("object");
            LocatedObjects lobjs = new LocatedObjects();
            for (int i = 0; i < objects.getLength(); ++i) {
                try {
                    Element object = (Element)objects.item(i);
                    String xmin = object.getElementsByTagName("xmin").item(0).getTextContent();
                    String xmax = object.getElementsByTagName("xmax").item(0).getTextContent();
                    String ymin = object.getElementsByTagName("ymin").item(0).getTextContent();
                    String ymax = object.getElementsByTagName("ymax").item(0).getTextContent();
                    String name = object.getElementsByTagName("name").item(0).getTextContent();
                    String pose = object.getElementsByTagName("pose").item(0).getTextContent();
                    String truncated = object.getElementsByTagName("truncated").item(0).getTextContent();
                    String occluded = object.getElementsByTagName("occluded").item(0).getTextContent();
                    LocatedObject lobj = new LocatedObject(null, Integer.parseInt(xmin), Integer.parseInt(ymin), Integer.parseInt(xmax) - Integer.parseInt(xmin) + 1, Integer.parseInt(ymax) - Integer.parseInt(ymin) + 1);
                    lobj.getMetaData().put("type", name);
                    lobj.getMetaData().put("pose", pose);
                    lobj.getMetaData().put("occluded", !occluded.equals("0"));
                    lobj.getMetaData().put("truncated", !truncated.equals("0"));
                    lobjs.add(lobj);
                    continue;
                }
                catch (Exception e) {
                    this.getLogger().log(Level.SEVERE, "Failed to parse object #" + (i + 1) + "!", (Throwable)e);
                }
            }
            result.add(lobjs.toReport(this.m_Prefix));
        } else {
            this.getLogger().severe("Failed to read " + this.m_Input + ":\n" + msg);
        }
        return result;
    }
}

