/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.io.FileUtils;
import adams.data.io.input.AbstractReportReader;
import adams.data.report.Report;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;

public class ViaAnnotationsReportReader
extends AbstractReportReader<Report> {
    private static final long serialVersionUID = 5716807404370681434L;
    protected String m_Prefix;
    protected String m_LabelKey;

    public String globalInfo() {
        return "Interprets polygon annotations generated by VGG Image Annotator.\nFor more information, see:\nhttp://www.robots.ox.ac.uk/~vgg/software/via/";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("prefix", "prefix", (Object)"Object.");
        this.m_OptionManager.add("label-key", "labelKey", (Object)"");
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The report field prefix used in the report.";
    }

    public void setLabelKey(String value) {
        this.m_LabelKey = value;
        this.reset();
    }

    public String getLabelKey() {
        return this.m_LabelKey;
    }

    public String labelKeyTipText() {
        return "The key in the meta-data containing the label, ignored if empty.";
    }

    public String getFormatDescription() {
        return "VGG Image Annotator (VIA)";
    }

    public String[] getFormatExtensions() {
        return new String[]{"json"};
    }

    protected int determineParentID(Report report) {
        return -1;
    }

    public Report newInstance() {
        return new Report();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Report> readData() {
        ArrayList<Report> result = new ArrayList<Report>();
        FileReader freader = null;
        BufferedReader breader = null;
        try {
            freader = new FileReader(this.m_Input.getAbsolutePath());
            breader = new BufferedReader(freader);
            JSONParser parser = new JSONParser(960);
            LocatedObjects lobjs = new LocatedObjects();
            JSONObject obj = (JSONObject)parser.parse((Reader)breader);
            for (String imgKey : obj.keySet()) {
                JSONObject img = (JSONObject)obj.get((Object)imgKey);
                String fname = img.getAsString("filename");
                JSONObject regions = (JSONObject)img.get((Object)"regions");
                for (String regionKey : regions.keySet()) {
                    JSONObject region = (JSONObject)regions.get((Object)regionKey);
                    JSONObject regionAtts = (JSONObject)region.get((Object)"region_attributes");
                    JSONObject shapeAtts = (JSONObject)region.get((Object)"shape_attributes");
                    String shapeName = shapeAtts.getAsString("name");
                    if (!shapeName.equals("polygon")) continue;
                    String label = null;
                    if (regionAtts != null && regionAtts.get((Object)"name") != null) {
                        label = "" + regionAtts.get((Object)"name");
                    }
                    JSONArray pointsX = (JSONArray)shapeAtts.get((Object)"all_points_x");
                    JSONArray pointsY = (JSONArray)shapeAtts.get((Object)"all_points_y");
                    int[] x = new int[pointsX.size()];
                    int[] y = new int[pointsY.size()];
                    for (int i = 0; i < pointsX.size(); ++i) {
                        x[i] = ((Number)pointsX.get(i)).intValue();
                        y[i] = ((Number)pointsY.get(i)).intValue();
                    }
                    Polygon polygon = new Polygon(x, y, x.length);
                    Rectangle rect = polygon.getBounds();
                    LocatedObject lobj = new LocatedObject(null, rect.x, rect.y, rect.width, rect.height);
                    lobj.setPolygon(polygon);
                    lobj.getMetaData().put("filename", fname);
                    lobj.getMetaData().put("region", regionKey);
                    if (label != null) {
                        lobj.getMetaData().put(this.m_LabelKey, label);
                    }
                    lobjs.add(lobj);
                }
            }
            result.add(lobjs.toReport(this.m_Prefix));
        }
        catch (Exception e) {
            try {
                this.getLogger().log(Level.SEVERE, "Failed to read JSON file: " + this.m_Input, (Throwable)e);
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(breader);
                FileUtils.closeQuietly(freader);
                throw throwable;
            }
            FileUtils.closeQuietly((Reader)breader);
            FileUtils.closeQuietly((Reader)freader);
        }
        FileUtils.closeQuietly((Reader)breader);
        FileUtils.closeQuietly((Reader)freader);
        return result;
    }
}

