/*
 * Decompiled with CFR 0.152.
 */
package adams.data.lire.features;

import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.data.featureconverter.HeaderDefinition;
import adams.data.image.BufferedImageContainer;
import adams.data.image.BufferedImageHelper;
import adams.data.image.features.AbstractBufferedImageFeatureGenerator;
import adams.data.report.DataType;
import adams.data.statistics.StatUtils;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.semanticmetadata.lire.imageanalysis.features.global.spatialpyramid.SPCEDD;

public class SpatialPyramidCEDD
extends AbstractBufferedImageFeatureGenerator
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -218939305183964139L;

    public String globalInfo() {
        return "Generates features using " + SPCEDD.class.getName() + ".\nFor more information, see:\n" + this.getTechnicalInformation().toString() + "\nFor more information on the LIRE project, see:\nhttp://www.lire-project.net/";
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Savvas A. Chatzichristofis and Yiannis S. Boutalis");
        result.setValue(TechnicalInformation.Field.TITLE, "CEDD: Color and Edge Directivity Descriptor. A Compact Descriptor for Image Indexing and Retrieval");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "6th International Conference on Computer Vision Systems");
        result.setValue(TechnicalInformation.Field.EDITOR, "A. Gasteratos, M. Vincze, and J.K. Tsotsos");
        result.setValue(TechnicalInformation.Field.YEAR, "2008");
        result.setValue(TechnicalInformation.Field.PAGES, "312-322");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Springer");
        return result;
    }

    @Override
    public HeaderDefinition createHeader(BufferedImageContainer img) {
        BufferedImage image = BufferedImageHelper.convert((BufferedImage)((BufferedImage)img.getImage()), (int)5);
        SPCEDD features = new SPCEDD();
        features.extract(image);
        double[] histo = features.getFeatureVector();
        HeaderDefinition result = new HeaderDefinition();
        for (int i = 0; i < histo.length; ++i) {
            result.add("SPCEDD-" + (i + 1), DataType.NUMERIC);
        }
        return result;
    }

    @Override
    public List<Object>[] generateRows(BufferedImageContainer img) {
        BufferedImage image = BufferedImageHelper.convert((BufferedImage)((BufferedImage)img.getImage()), (int)5);
        SPCEDD features = new SPCEDD();
        features.extract(image);
        double[] histo = features.getFeatureVector();
        List[] result = new List[]{new ArrayList()};
        result[0].addAll(Arrays.asList(StatUtils.toNumberArray((double[])histo)));
        return result;
    }
}

