/*
 * Decompiled with CFR 0.152.
 */
package adams.data.objectfilter;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.objectfilter.AbstractObjectFilter;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import java.awt.Polygon;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class Rotate
extends AbstractObjectFilter {
    private static final long serialVersionUID = -2181381799680316619L;
    protected double m_Angle;
    protected int m_ImageWidth;
    protected int m_ImageHeight;

    public String globalInfo() {
        return "Rotates the objects using the specified degrees.\nRequires the original image width before the image got rotated in order to rotate the objects correctly.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("angle", "angle", (Object)0.0);
        this.m_OptionManager.add("image-width", "imageWidth", (Object)640, (Number)1, null);
        this.m_OptionManager.add("image-height", "imageHeight", (Object)480, (Number)1, null);
    }

    public void setAngle(double value) {
        this.m_Angle = value;
        this.reset();
    }

    public double getAngle() {
        return this.m_Angle;
    }

    public String angleTipText() {
        return "The rotation angle in degrees.";
    }

    public void setImageWidth(int value) {
        if (this.getOptionManager().isValid("imageWidth", (Number)value)) {
            this.m_ImageWidth = value;
            this.reset();
        }
    }

    public int getImageWidth() {
        return this.m_ImageWidth;
    }

    public String imageWidthTipText() {
        return "The original image width before rotation.";
    }

    public void setImageHeight(int value) {
        if (this.getOptionManager().isValid("imageHeight", (Number)value)) {
            this.m_ImageHeight = value;
            this.reset();
        }
    }

    public int getImageHeight() {
        return this.m_ImageHeight;
    }

    public String imageHeightTipText() {
        return "The original image height before rotation.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"angle", (Object)this.m_Angle, (String)"angle: ");
        return result;
    }

    @Override
    protected LocatedObjects doFilter(LocatedObjects objects) {
        LocatedObjects result = new LocatedObjects();
        double theta = this.m_Angle / 180.0 * Math.PI;
        AffineTransform trans = AffineTransform.getRotateInstance(theta, this.m_ImageWidth / 2, this.m_ImageHeight / 2);
        for (LocatedObject obj : objects) {
            int i;
            int[] ypoints;
            int[] xpoints;
            int x = obj.getX();
            int y = obj.getY();
            int w = obj.getWidth();
            int h = obj.getHeight();
            Point2D.Double tl = new Point2D.Double(x, y);
            Point2D.Double br = new Point2D.Double(x + w - 1, y + h - 1);
            Point2D.Double tlN = new Point2D.Double();
            Point2D.Double brN = new Point2D.Double();
            Point2D[] polyP = new Point2D[]{};
            Point2D[] polyPN = new Point2D[]{};
            boolean hasPoly = obj.hasPolygon();
            if (hasPoly) {
                Polygon poly = obj.getPolygon();
                xpoints = poly.xpoints;
                ypoints = poly.ypoints;
                polyP = new Point2D[xpoints.length];
                polyPN = new Point2D[xpoints.length];
                for (i = 0; i < xpoints.length; ++i) {
                    polyP[i] = new Point2D.Double(xpoints[i], ypoints[i]);
                    polyPN[i] = new Point2D.Double();
                }
            }
            trans.transform(tl, tlN);
            trans.transform(br, brN);
            if (hasPoly) {
                trans.transform(polyP, 0, polyPN, 0, polyP.length);
            }
            int xN = (int)((Point2D)tlN).getX();
            int yN = (int)((Point2D)tlN).getY();
            int wN = (int)(((Point2D)brN).getX() - ((Point2D)tlN).getX() + 1.0);
            int hN = (int)(((Point2D)brN).getY() - ((Point2D)tlN).getY() + 1.0);
            LocatedObject newObj = new LocatedObject(obj.getImage(), xN, yN, wN, hN, obj.getMetaData(true));
            if (hasPoly) {
                xpoints = new int[polyPN.length];
                ypoints = new int[polyPN.length];
                for (i = 0; i < polyPN.length; ++i) {
                    xpoints[i] = (int)polyPN[i].getX();
                    ypoints[i] = (int)polyPN[i].getY();
                }
                newObj.setPolygon(new Polygon(xpoints, ypoints, xpoints.length));
            }
            result.add(newObj);
        }
        return result;
    }
}

