/*
 * Decompiled with CFR 0.152.
 */
package adams.data.objectfilter;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.RoundingType;
import adams.data.objectfilter.AbstractObjectFilter;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import java.awt.Polygon;

public class Scale
extends AbstractObjectFilter {
    private static final long serialVersionUID = -2181381799680316619L;
    protected double m_ScaleX;
    protected double m_ScaleY;
    protected boolean m_Round;
    protected RoundingType m_RoundingType;

    public String globalInfo() {
        return "Scales the objects.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("scale-x", "scaleX", (Object)1.0, (Number)0.0, null);
        this.m_OptionManager.add("scale-y", "scaleY", (Object)1.0, (Number)0.0, null);
        this.m_OptionManager.add("round", "round", (Object)false);
        this.m_OptionManager.add("rounding-type", "roundingType", (Object)RoundingType.ROUND);
    }

    public void setScaleX(double value) {
        if (this.getOptionManager().isValid("scaleX", (Number)value)) {
            this.m_ScaleX = value;
            this.reset();
        }
    }

    public double getScaleX() {
        return this.m_ScaleX;
    }

    public String scaleXTipText() {
        return "The factor for scaling x/width.";
    }

    public void setScaleY(double value) {
        if (this.getOptionManager().isValid("scaleY", (Number)value)) {
            this.m_ScaleY = value;
            this.reset();
        }
    }

    public double getScaleY() {
        return this.m_ScaleY;
    }

    public String scaleYTipText() {
        return "The factor for scaling y/width.";
    }

    public void setRound(boolean value) {
        this.m_Round = value;
        this.reset();
    }

    public boolean getRound() {
        return this.m_Round;
    }

    public String roundTipText() {
        return "If enabled, the scaled values get round.";
    }

    public void setRoundingType(RoundingType value) {
        this.m_RoundingType = value;
        this.reset();
    }

    public RoundingType getRoundingType() {
        return this.m_RoundingType;
    }

    public String roundingTypeTipText() {
        return "The type of rounding to perform.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"scaleX", (Object)this.m_ScaleX, (String)"x: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"scaleY", (Object)this.m_ScaleY, (String)", y: ");
        if (this.m_Round) {
            result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"roundingType", (Object)this.m_RoundingType, (String)", rounding: ");
        }
        return result;
    }

    protected double round(double value) {
        if (!this.m_Round) {
            return value;
        }
        switch (this.m_RoundingType) {
            case ROUND: {
                return Math.round(value);
            }
            case FLOOR: {
                return Math.floor(value);
            }
            case CEILING: {
                return Math.ceil(value);
            }
        }
        throw new IllegalStateException("Unhandled rounding type: " + this.m_RoundingType);
    }

    @Override
    protected LocatedObjects doFilter(LocatedObjects objects) {
        LocatedObjects result = new LocatedObjects();
        for (LocatedObject obj : objects) {
            boolean hasPoly = obj.hasPolygon();
            int[] xpoints = new int[]{};
            int[] ypoints = new int[]{};
            if (hasPoly) {
                xpoints = (int[])obj.getPolygon().xpoints.clone();
                ypoints = (int[])obj.getPolygon().ypoints.clone();
                int i = 0;
                while (i < xpoints.length) {
                    int n = i;
                    xpoints[n] = (int)((double)xpoints[n] * this.m_ScaleX);
                    int n2 = i++;
                    ypoints[n2] = (int)((double)ypoints[n2] * this.m_ScaleY);
                }
            }
            LocatedObject newObj = new LocatedObject(obj.getImage(), (int)this.round((double)obj.getX() * this.m_ScaleX), (int)this.round((double)obj.getY() * this.m_ScaleY), (int)this.round((double)obj.getWidth() * this.m_ScaleX), (int)this.round((double)obj.getHeight() * this.m_ScaleY), obj.getMetaData(true));
            if (hasPoly) {
                newObj.setPolygon(new Polygon(xpoints, ypoints, xpoints.length));
            }
            result.add(newObj);
        }
        return result;
    }
}

