/*
 * Decompiled with CFR 0.152.
 */
package adams.data.objectfilter;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.objectfilter.AbstractObjectFilter;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import java.awt.Polygon;

public class Translate
extends AbstractObjectFilter {
    private static final long serialVersionUID = -2181381799680316619L;
    protected int m_X;
    protected int m_Y;

    public String globalInfo() {
        return "Translates the objects by the specified X and Y.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("x", "X", (Object)0);
        this.m_OptionManager.add("y", "Y", (Object)0);
    }

    public void setX(int value) {
        if (this.getOptionManager().isValid("X", (Number)value)) {
            this.m_X = value;
            this.reset();
        }
    }

    public int getX() {
        return this.m_X;
    }

    public String XTipText() {
        return "The translation on the X axis.";
    }

    public void setY(int value) {
        if (this.getOptionManager().isValid("scaleY", (Number)value)) {
            this.m_Y = value;
            this.reset();
        }
    }

    public int getY() {
        return this.m_Y;
    }

    public String YTipText() {
        return "The translation on the Y axis.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"X", (Object)this.m_X, (String)"x: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"Y", (Object)this.m_Y, (String)", y: ");
        return result;
    }

    @Override
    protected LocatedObjects doFilter(LocatedObjects objects) {
        LocatedObjects result = new LocatedObjects();
        for (LocatedObject obj : objects) {
            boolean hasPoly = obj.hasPolygon();
            int[] xpoints = new int[]{};
            int[] ypoints = new int[]{};
            if (hasPoly) {
                xpoints = (int[])obj.getPolygon().xpoints.clone();
                ypoints = (int[])obj.getPolygon().ypoints.clone();
                int i = 0;
                while (i < xpoints.length) {
                    int n = i;
                    xpoints[n] = xpoints[n] + this.m_X;
                    int n2 = i++;
                    ypoints[n2] = ypoints[n2] + this.m_Y;
                }
            }
            LocatedObject newObj = new LocatedObject(obj.getImage(), obj.getX() + this.m_X, obj.getY() + this.m_Y, obj.getWidth(), obj.getHeight(), obj.getMetaData(true));
            if (hasPoly) {
                newObj.setPolygon(new Polygon(xpoints, ypoints, xpoints.length));
            }
            result.add(newObj);
        }
        return result;
    }
}

