/*
 * Decompiled with CFR 0.152.
 */
package adams.data.objectfinder;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseRegExp;
import adams.core.option.OptionHandler;
import adams.data.objectfinder.AbstractObjectFinder;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import gnu.trove.list.array.TIntArrayList;

public class ObjectsInRegion
extends AbstractObjectFinder {
    private static final long serialVersionUID = -6804833277425617270L;
    protected int m_Top;
    protected int m_Left;
    protected int m_Height;
    protected int m_Width;
    protected boolean m_Partial;
    protected boolean m_OneBased;
    protected boolean m_CheckType;
    protected String m_TypeSuffix;
    protected BaseRegExp m_TypeFind;

    public String globalInfo() {
        return "Locates the objects that fall into the defined region.\nPartial hits can be considered as well.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("top", "top", (Object)1, (Number)1, null);
        this.m_OptionManager.add("left", "left", (Object)1, (Number)1, null);
        this.m_OptionManager.add("height", "height", (Object)1, (Number)1, null);
        this.m_OptionManager.add("width", "width", (Object)1, (Number)1, null);
        this.m_OptionManager.add("partial", "partial", (Object)false);
        this.m_OptionManager.add("one-based", "oneBased", (Object)false);
        this.m_OptionManager.add("check-type", "checkType", (Object)false);
        this.m_OptionManager.add("type-suffix", "typeSuffix", (Object)"");
        this.m_OptionManager.add("type-find", "typeFind", (Object)new BaseRegExp(""));
    }

    public void setTop(int value) {
        if (this.getOptionManager().isValid("top", (Number)value)) {
            this.m_Top = value;
            this.reset();
        }
    }

    public int getTop() {
        return this.m_Top;
    }

    public String topTipText() {
        return "The y position of the top-left corner.";
    }

    public void setLeft(int value) {
        if (this.getOptionManager().isValid("left", (Number)value)) {
            this.m_Left = value;
            this.reset();
        }
    }

    public int getLeft() {
        return this.m_Left;
    }

    public String leftTipText() {
        return "The x position of the top-left corner.";
    }

    public void setHeight(int value) {
        if (this.getOptionManager().isValid("height", (Number)value)) {
            this.m_Height = value;
            this.reset();
        }
    }

    public int getHeight() {
        return this.m_Height;
    }

    public String heightTipText() {
        return "The height of the region.";
    }

    public void setWidth(int value) {
        if (this.getOptionManager().isValid("width", (Number)value)) {
            this.m_Width = value;
            this.reset();
        }
    }

    public int getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The width of the region.";
    }

    public void setPartial(boolean value) {
        this.m_Partial = value;
        this.reset();
    }

    public boolean getPartial() {
        return this.m_Partial;
    }

    public String partialTipText() {
        return "If enabled, partial hits are included as well.";
    }

    public void setOneBased(boolean value) {
        this.m_OneBased = value;
        this.reset();
    }

    public boolean getOneBased() {
        return this.m_OneBased;
    }

    public String oneBasedTipText() {
        return "If enabled, coordinates in the report are assumed to be 1-based instead of 0-based.";
    }

    public void setCheckType(boolean value) {
        this.m_CheckType = value;
        this.reset();
    }

    public boolean getCheckType() {
        return this.m_CheckType;
    }

    public String checkTypeTipText() {
        return "If enabled, the type of the objects gets checked as well.";
    }

    public void setTypeSuffix(String value) {
        this.m_TypeSuffix = value;
        this.reset();
    }

    public String getTypeSuffix() {
        return this.m_TypeSuffix;
    }

    public String typeSuffixTipText() {
        return "The report field suffix for the type used in the report (ignored if no check).";
    }

    public void setTypeFind(BaseRegExp value) {
        this.m_TypeFind = value;
        this.reset();
    }

    public BaseRegExp getTypeFind() {
        return this.m_TypeFind;
    }

    public String typeFindTipText() {
        return "The regular expression to apply to the type, ignored if no check.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"prefix", (Object)this.m_Prefix, (String)"prefix: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"left", (Object)this.m_Left, (String)", l: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"top", (Object)this.m_Top, (String)", t: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"width", (Object)this.m_Width, (String)", w: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"height", (Object)this.m_Height, (String)", h: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"partialCounts", (boolean)this.m_Partial, (String)"partial", (String)", ");
        if (this.m_CheckType) {
            result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"typeSuffix", (Object)(this.m_TypeSuffix.isEmpty() ? "-missing-" : this.m_TypeSuffix), (String)", type suffix: ");
            result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"typeFind", (Object)(this.m_TypeFind.isEmpty() ? "-missing-" : this.m_TypeFind), (String)", type find: ");
        }
        return result;
    }

    @Override
    protected int[] doFind(LocatedObjects objects) {
        TIntArrayList result = new TIntArrayList();
        String typeKey = this.m_TypeSuffix.startsWith(".") ? this.m_TypeSuffix.substring(1) : this.m_TypeSuffix;
        LocatedObject region = new LocatedObject(null, this.m_Left - (this.m_OneBased ? 0 : 1), this.m_Top - (this.m_OneBased ? 0 : 1), this.m_Width, this.m_Height);
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Region: " + region);
        }
        for (LocatedObject obj : objects) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Object: " + obj);
            }
            boolean add = true;
            if (this.m_CheckType) {
                boolean bl = add = obj.getMetaData().containsKey(this.m_TypeSuffix) && this.m_TypeFind.isMatch(obj.getMetaData().get(typeKey).toString());
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("Type check: " + add);
                }
            }
            if (!add) continue;
            double overlap = obj.overlapRatio(region);
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Overlap: " + overlap);
            }
            if (overlap == 1.0) {
                result.add(obj.getIndex());
                continue;
            }
            if (!(overlap > 0.0) || !(overlap < 1.0) || !this.m_Partial) continue;
            result.add(obj.getIndex());
        }
        return result.toArray();
    }
}

