/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseRegExp;
import adams.core.option.OptionHandler;
import adams.data.objectfinder.ObjectsInRegion;
import adams.data.report.Report;
import adams.data.report.ReportHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import gnu.trove.set.hash.TIntHashSet;

public class CountObjectsInRegion
extends AbstractTransformer {
    private static final long serialVersionUID = 9063650105550850888L;
    protected int m_Top;
    protected int m_Left;
    protected int m_Height;
    protected int m_Width;
    protected boolean m_PartialCounts;
    protected boolean m_OneBased;
    protected String m_Prefix;
    protected boolean m_CheckType;
    protected String m_TypeSuffix;
    protected BaseRegExp m_TypeFind;

    public String globalInfo() {
        return "Counts the objects in the report passing through that fall into the defined region.\nPartial hits can be counted as well, using their percentage in overlap as count.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("top", "top", (Object)1, (Number)1, null);
        this.m_OptionManager.add("left", "left", (Object)1, (Number)1, null);
        this.m_OptionManager.add("height", "height", (Object)1, (Number)1, null);
        this.m_OptionManager.add("width", "width", (Object)1, (Number)1, null);
        this.m_OptionManager.add("partial-counts", "partialCounts", (Object)false);
        this.m_OptionManager.add("one-based", "oneBased", (Object)false);
        this.m_OptionManager.add("prefix", "prefix", (Object)"Object.");
        this.m_OptionManager.add("check-type", "checkType", (Object)false);
        this.m_OptionManager.add("type-suffix", "typeSuffix", (Object)"");
        this.m_OptionManager.add("type-find", "typeFind", (Object)new BaseRegExp(""));
    }

    public void setTop(int value) {
        if (this.getOptionManager().isValid("top", (Number)value)) {
            this.m_Top = value;
            this.reset();
        }
    }

    public int getTop() {
        return this.m_Top;
    }

    public String topTipText() {
        return "The y position of the top-left corner.";
    }

    public void setLeft(int value) {
        if (this.getOptionManager().isValid("left", (Number)value)) {
            this.m_Left = value;
            this.reset();
        }
    }

    public int getLeft() {
        return this.m_Left;
    }

    public String leftTipText() {
        return "The x position of the top-left corner.";
    }

    public void setHeight(int value) {
        if (this.getOptionManager().isValid("height", (Number)value)) {
            this.m_Height = value;
            this.reset();
        }
    }

    public int getHeight() {
        return this.m_Height;
    }

    public String heightTipText() {
        return "The height of the region.";
    }

    public void setWidth(int value) {
        if (this.getOptionManager().isValid("width", (Number)value)) {
            this.m_Width = value;
            this.reset();
        }
    }

    public int getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The width of the region.";
    }

    public void setPartialCounts(boolean value) {
        this.m_PartialCounts = value;
        this.reset();
    }

    public boolean getPartialCounts() {
        return this.m_PartialCounts;
    }

    public String partialCountsTipText() {
        return "If enabled, partial hits are counted as well (using their fraction in overlap as count).";
    }

    public void setOneBased(boolean value) {
        this.m_OneBased = value;
        this.reset();
    }

    public boolean getOneBased() {
        return this.m_OneBased;
    }

    public String oneBasedTipText() {
        return "If enabled, coordinates in the report are assumed to be 1-based instead of 0-based.";
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The report field prefix used in the report.";
    }

    public void setCheckType(boolean value) {
        this.m_CheckType = value;
        this.reset();
    }

    public boolean getCheckType() {
        return this.m_CheckType;
    }

    public String checkTypeTipText() {
        return "If enabled, the type of the objects gets checked as well.";
    }

    public void setTypeSuffix(String value) {
        this.m_TypeSuffix = value;
        this.reset();
    }

    public String getTypeSuffix() {
        return this.m_TypeSuffix;
    }

    public String typeSuffixTipText() {
        return "The report field suffix for the type used in the report (ignored if no check).";
    }

    public void setTypeFind(BaseRegExp value) {
        this.m_TypeFind = value;
        this.reset();
    }

    public BaseRegExp getTypeFind() {
        return this.m_TypeFind;
    }

    public String typeFindTipText() {
        return "The regular expression to apply to the type, ignored if no check.";
    }

    public Class[] accepts() {
        return new Class[]{Report.class, ReportHandler.class};
    }

    public Class[] generates() {
        return new Class[]{Double.class};
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"prefix", (Object)this.m_Prefix, (String)"prefix: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"left", (Object)this.m_Left, (String)", l: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"top", (Object)this.m_Top, (String)", t: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"width", (Object)this.m_Width, (String)", w: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"height", (Object)this.m_Height, (String)", h: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"partialCounts", (boolean)this.m_PartialCounts, (String)"partial", (String)", ");
        if (this.m_CheckType) {
            result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"typeSuffix", (Object)(this.m_TypeSuffix.isEmpty() ? "-missing-" : this.m_TypeSuffix), (String)", type suffix: ");
            result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"typeFind", (Object)(this.m_TypeFind.isEmpty() ? "-missing-" : this.m_TypeFind), (String)", type find: ");
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        Report report = null;
        if (this.m_InputToken.hasPayload(Report.class)) {
            report = (Report)this.m_InputToken.getPayload(Report.class);
        } else if (this.m_InputToken.hasPayload(ReportHandler.class)) {
            report = ((ReportHandler)this.m_InputToken.getPayload(ReportHandler.class)).getReport();
        } else {
            result = this.m_InputToken.unhandledData();
        }
        if (report != null) {
            ObjectsInRegion finder = new ObjectsInRegion();
            finder.setTop(this.m_Top);
            finder.setLeft(this.m_Left);
            finder.setHeight(this.m_Height);
            finder.setWidth(this.m_Width);
            finder.setPartial(this.m_PartialCounts);
            finder.setOneBased(this.m_OneBased);
            finder.setPrefix(this.m_Prefix);
            finder.setCheckType(this.m_CheckType);
            finder.setTypeSuffix(this.m_TypeSuffix);
            finder.setTypeFind(this.m_TypeFind);
            TIntHashSet indices = new TIntHashSet(finder.find(report));
            double count = 0.0;
            LocatedObjects objs = LocatedObjects.fromReport(report, this.m_Prefix);
            LocatedObject region = new LocatedObject(null, this.m_Left - (this.m_OneBased ? 0 : 1), this.m_Top - (this.m_OneBased ? 0 : 1), this.m_Width, this.m_Height);
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Region: " + region);
            }
            for (LocatedObject obj : objs) {
                if (!indices.contains(obj.getIndex())) continue;
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("Object: " + obj);
                }
                double overlap = obj.overlapRatio(region);
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("Overlap: " + overlap);
                }
                if (overlap == 1.0) {
                    count += 1.0;
                    continue;
                }
                if (!(overlap > 0.0) || !(overlap < 1.0) || !this.m_PartialCounts) continue;
                count += overlap;
            }
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Count: " + count);
            }
            this.m_OutputToken = new Token((Object)count);
        }
        return result;
    }
}

