/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseString;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.data.image.AbstractImageContainer;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractInteractiveTransformerDialog;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import adams.gui.core.BaseButton;
import adams.gui.core.BaseDialog;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.event.ImagePanelLeftClickEvent;
import adams.gui.event.ImagePanelLeftClickListener;
import adams.gui.event.ImagePanelSelectionListener;
import adams.gui.visualization.image.ImageOverlay;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.NullOverlay;
import adams.gui.visualization.image.selection.NullProcessor;
import adams.gui.visualization.image.selection.SelectionProcessor;
import adams.gui.visualization.image.selection.SelectionProcessorWithLabelSupport;
import adams.gui.visualization.image.selectionshape.RectanglePainter;
import adams.gui.visualization.image.selectionshape.SelectionShapePainter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class ImageAnnotator
extends AbstractInteractiveTransformerDialog {
    private static final long serialVersionUID = -3374468402777151698L;
    protected String m_Prefix;
    protected String m_Suffix;
    protected BaseString[] m_Labels;
    protected SelectionProcessor m_SelectionProcessor;
    protected SelectionShapePainter m_SelectionShapePainter;
    protected ImageOverlay m_Overlay;
    protected double m_Zoom;
    protected boolean m_Accepted;

    public String globalInfo() {
        return "Allows the user to label objects located on the image and pass on this enriched meta-data.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("prefix", "prefix", (Object)"Object.");
        this.m_OptionManager.add("suffix", "suffix", (Object)".type");
        this.m_OptionManager.add("label", "labels", (Object)new BaseString[0]);
        this.m_OptionManager.add("selection-processor", "selectionProcessor", (Object)new NullProcessor());
        this.m_OptionManager.add("selection-shape-painter", "selectionShapePainter", (Object)new RectanglePainter());
        this.m_OptionManager.add("overlay", "overlay", (Object)new NullOverlay());
        this.m_OptionManager.add("zoom", "zoom", (Object)100.0, (Number)-1.0, (Number)1600.0);
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The report field prefix to use for the located objects.";
    }

    public void setSuffix(String value) {
        this.m_Suffix = value;
        this.reset();
    }

    public String getSuffix() {
        return this.m_Suffix;
    }

    public String suffixTipText() {
        return "The report field suffix to use for the labels.";
    }

    public void setLabels(BaseString[] value) {
        this.m_Labels = value;
        this.reset();
    }

    public BaseString[] getLabels() {
        return this.m_Labels;
    }

    public String labelsTipText() {
        return "The labels to use.";
    }

    public void setSelectionProcessor(SelectionProcessor value) {
        this.m_SelectionProcessor = value;
        this.reset();
    }

    public SelectionProcessor getSelectionProcessor() {
        return this.m_SelectionProcessor;
    }

    public String selectionProcessorTipText() {
        return "The selection processor to use.";
    }

    public void setSelectionShapePainter(SelectionShapePainter value) {
        this.m_SelectionShapePainter = value;
        this.reset();
    }

    public SelectionShapePainter getSelectionShapePainter() {
        return this.m_SelectionShapePainter;
    }

    public String selectionShapePainterTipText() {
        return "The painter to use for the selection shape.";
    }

    public void setOverlay(ImageOverlay value) {
        this.m_Overlay = value;
        this.reset();
    }

    public ImageOverlay getOverlay() {
        return this.m_Overlay;
    }

    public String overlayTipText() {
        return "The overlay to use for highlighting the objects.";
    }

    public void setZoom(double value) {
        if (value == -1.0 || value > 0.0 && value <= 1600.0) {
            this.m_Zoom = value;
            this.reset();
        } else {
            this.getLogger().warning("Zoom must -1 to fit window or 0 < x < 1600, provided: " + value);
        }
    }

    public double getZoom() {
        return this.m_Zoom;
    }

    public String zoomTipText() {
        return "The zoom level in percent.";
    }

    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"selectionProcessor", (Object)this.m_SelectionProcessor, (String)", selection: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"overlay", (Object)this.m_Overlay, (String)", overlay: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"labels", (Object)this.m_Labels, (String)", labels: ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{AbstractImageContainer.class};
    }

    public Class[] generates() {
        return new Class[]{AbstractImageContainer.class};
    }

    public void clearPanel() {
    }

    protected BasePanel newPanel() {
        return new AnnotatorPanel();
    }

    protected void postCreateDialog(BaseDialog dialog, BasePanel panel) {
        JPanel panelButtons = new JPanel(new FlowLayout(2));
        dialog.getContentPane().add((Component)panelButtons, "South");
        BaseButton buttonOK = new BaseButton("OK");
        buttonOK.addActionListener(e -> {
            this.m_Accepted = true;
            dialog.setVisible(false);
        });
        panelButtons.add((Component)buttonOK);
        BaseButton buttonCancel = new BaseButton("Cancel");
        buttonCancel.addActionListener(e -> {
            this.m_Accepted = false;
            dialog.setVisible(false);
        });
        panelButtons.add((Component)buttonCancel);
    }

    public boolean doInteract() {
        this.m_Accepted = false;
        AbstractImageContainer cont = (AbstractImageContainer)this.m_InputToken.getPayload();
        this.registerWindow((Window)this.m_Dialog, this.m_Dialog.getTitle());
        ((AnnotatorPanel)this.m_Panel).setCurrentImage(cont);
        this.m_Dialog.setVisible(true);
        this.deregisterWindow((Window)this.m_Dialog);
        if (this.m_Accepted) {
            cont = ((AnnotatorPanel)this.m_Panel).getCurrentImage();
            cont.setReport(((AnnotatorPanel)this.m_Panel).getCurrentReport());
            this.m_OutputToken = new Token((Object)cont);
        }
        return this.m_Accepted;
    }

    public class AnnotatorPanel
    extends BasePanel
    implements ImagePanelLeftClickListener {
        private static final long serialVersionUID = 301202246788374114L;
        protected JToggleButton[] m_ButtonLabels;
        protected JToggleButton m_ButtonUnset;
        protected BaseButton m_ButtonReset;
        protected ButtonGroup m_ButtonGroup;
        protected ImagePanel m_PanelImage;
        protected String m_CurrentLabel;
        protected AbstractImageContainer m_CurrentImage;
        protected Report m_ReportBackup;
        protected LocatedObjects m_Objects;
        protected Double m_CurrentScale;
        protected SelectionProcessor m_ActualSelectionProcessor;

        protected void initialize() {
            super.initialize();
            this.m_CurrentLabel = null;
            if (ImageAnnotator.this.m_Labels.length > 0) {
                this.m_CurrentLabel = ImageAnnotator.this.m_Labels[0].getValue();
            }
            this.m_CurrentImage = null;
            this.m_ReportBackup = null;
            this.m_Objects = new LocatedObjects();
            this.m_CurrentScale = null;
            this.m_ActualSelectionProcessor = null;
        }

        protected void initGUI() {
            GridBagConstraints con;
            int i;
            super.initGUI();
            this.setLayout(new BorderLayout());
            JPanel panelLeft = new JPanel(new BorderLayout(5, 5));
            this.add(panelLeft, "West");
            int gapHorizontal = 5;
            int gapVertical = 2;
            GridBagLayout layout = new GridBagLayout();
            JPanel panelButtons = new JPanel(layout);
            panelLeft.add((Component)new BaseScrollPane((Component)panelButtons), "Center");
            this.m_ButtonGroup = new ButtonGroup();
            ArrayList<JToggleButton> comps = new ArrayList<JToggleButton>();
            this.m_ButtonLabels = new JToggleButton[ImageAnnotator.this.m_Labels.length];
            for (i = 0; i < ImageAnnotator.this.m_Labels.length; ++i) {
                String label = ImageAnnotator.this.m_Labels[i].getValue();
                this.m_ButtonLabels[i] = new JToggleButton(label);
                this.m_ButtonLabels[i].addActionListener(e -> this.setCurrentLabel(label));
                if (i == 0) {
                    this.m_ButtonLabels[i].setSelected(true);
                }
                this.m_ButtonGroup.add(this.m_ButtonLabels[i]);
                comps.add(this.m_ButtonLabels[i]);
            }
            this.m_ButtonUnset = new JToggleButton("Unset");
            this.m_ButtonUnset.addActionListener(e -> this.setCurrentLabel(null));
            comps.add(this.m_ButtonUnset);
            this.m_ButtonGroup.add(this.m_ButtonUnset);
            this.m_ButtonReset = new BaseButton("Reset");
            this.m_ButtonReset.addActionListener(e -> this.resetLabels());
            comps.add((JToggleButton)this.m_ButtonReset);
            for (i = 0; i < comps.size(); ++i) {
                con = new GridBagConstraints();
                con.anchor = 17;
                con.fill = 2;
                con.gridy = i;
                con.gridx = 0;
                con.weightx = 100.0;
                con.ipadx = 20;
                con.insets = new Insets(gapVertical, gapHorizontal, gapVertical, gapHorizontal);
                layout.setConstraints((Component)comps.get(i), con);
                panelButtons.add((Component)comps.get(i));
            }
            JPanel panel = new JPanel();
            con = new GridBagConstraints();
            con.anchor = 17;
            con.fill = 1;
            con.gridy = comps.size();
            con.gridx = 0;
            con.weighty = 100.0;
            con.gridwidth = 0;
            layout.setConstraints(panel, con);
            panelButtons.add(panel);
            this.m_PanelImage = new ImagePanel();
            this.m_PanelImage.setShowProperties(true);
            this.m_PanelImage.setScale(ImageAnnotator.this.m_Zoom);
            this.m_PanelImage.addLeftClickListener((ImagePanelLeftClickListener)this);
            this.m_PanelImage.addImageOverlay((ImageOverlay)OptionUtils.shallowCopy((Object)ImageAnnotator.this.m_Overlay));
            this.m_ActualSelectionProcessor = (SelectionProcessor)ImageAnnotator.this.m_SelectionProcessor.shallowCopy();
            this.m_PanelImage.addSelectionListener((ImagePanelSelectionListener)this.m_ActualSelectionProcessor);
            this.m_PanelImage.setSelectionShapePainter((SelectionShapePainter)OptionUtils.shallowCopy((Object)ImageAnnotator.this.m_SelectionShapePainter));
            this.m_PanelImage.setSelectionEnabled(true);
            this.add((Component)this.m_PanelImage, "Center");
        }

        protected void finishInit() {
            super.finishInit();
            if (this.m_ButtonLabels.length > 0) {
                this.m_ButtonLabels[0].doClick();
            }
        }

        protected void setCurrentLabel(String label) {
            this.m_CurrentLabel = label;
            if (this.m_ActualSelectionProcessor instanceof SelectionProcessorWithLabelSupport) {
                ((SelectionProcessorWithLabelSupport)this.m_ActualSelectionProcessor).setLabel(label == null ? "" : label);
            }
        }

        protected void resetLabels() {
            this.m_CurrentImage.setReport(this.m_ReportBackup.getClone());
            this.m_PanelImage.setCurrentImage(this.m_CurrentImage, this.m_PanelImage.getScale());
            this.updateObjects();
        }

        public void setCurrentImage(AbstractImageContainer value) {
            this.m_ReportBackup = value.getReport().getClone();
            this.m_CurrentImage = value;
            this.m_PanelImage.setCurrentImage(value);
        }

        public AbstractImageContainer getCurrentImage() {
            return this.m_CurrentImage;
        }

        public Report getCurrentReport() {
            return this.m_PanelImage.getAdditionalProperties();
        }

        protected void updateObjects() {
            if (this.m_CurrentImage == null) {
                this.m_Objects = new LocatedObjects();
                return;
            }
            Report report = this.m_PanelImage.getAdditionalProperties();
            if (report == null) {
                report = this.m_CurrentImage.getReport();
            }
            LocatedObjects located = LocatedObjects.fromReport(report, ImageAnnotator.this.m_Prefix);
            double actual = this.m_PanelImage.calcActualScale(this.m_PanelImage.getScale());
            located.scale(actual);
            this.m_Objects = located;
        }

        public void imageChanged(ImagePanel.PaintPanel panel) {
            if (ImageAnnotator.this.isLoggingEnabled()) {
                ImageAnnotator.this.getLogger().info("Updating objects");
            }
            this.updateObjects();
        }

        public void clicked(ImagePanelLeftClickEvent e) {
            double actual = this.m_PanelImage.calcActualScale(this.m_PanelImage.getScale());
            if (this.m_CurrentScale == null || this.m_CurrentScale != actual) {
                this.updateObjects();
                this.m_CurrentScale = actual;
            }
            boolean hit = false;
            Report report = this.m_PanelImage.getAdditionalProperties();
            for (LocatedObject obj : this.m_Objects) {
                boolean contained = obj.hasPolygon() ? obj.getActualPolygon().contains(e.getPosition()) : obj.getActualRectangle().contains(e.getPosition());
                if (!contained) continue;
                hit = true;
                Field field = new Field(ImageAnnotator.this.m_Prefix + obj.getIndexString() + ImageAnnotator.this.m_Suffix, DataType.STRING);
                if (this.m_CurrentLabel == null) {
                    report.removeValue((AbstractField)field);
                    break;
                }
                report.setValue((AbstractField)field, (Object)this.m_CurrentLabel);
                break;
            }
            if (hit) {
                this.m_PanelImage.setAdditionalProperties(report);
                this.m_PanelImage.displayProperties();
                this.updateObjects();
            }
        }
    }
}

