/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.data.image.AbstractImageContainer;
import adams.data.objectfinder.AllFinder;
import adams.data.objectfinder.ObjectFinder;
import adams.data.report.AbstractField;
import adams.data.report.MutableReportHandler;
import adams.data.report.Report;
import adams.data.report.ReportHandler;
import adams.flow.control.StorageName;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;

public class ImageObjectOverlap
extends AbstractTransformer {
    private static final long serialVersionUID = 8175397929496972306L;
    public static final String OVERLAP_PERCENTAGE_HIGHEST = "overlap_highest";
    public static final String OVERLAP_LABEL_HIGHEST = "overlap_label_highest";
    public static final String OVERLAP_LABEL_HIGHEST_MATCH = "overlap_label_highest_match";
    public static final String OVERLAP_COUNT = "overlap_count";
    public static final String UNKNOWN_LABEL = "???";
    protected StorageName m_StorageName;
    protected ObjectFinder m_Finder;
    protected double m_MinOverlapRatio;
    protected String m_LabelKey;
    protected boolean m_UseOtherObject;

    public String globalInfo() {
        return "Computes the overlap of objects with the specified report from storage.\nIt stores the overlap percentage of the highest overlap found (overlap_highest) and the total number of overlaps greater than the specified minimum (overlap_count).\nIf a label key (located object meta-data) has been supplied, then the label of the object with the highest overlap gets stored as well (overlap_label_highest) and whether the labels match (overlap_label_highest_match)";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("storage-name", "storageName", (Object)new StorageName());
        this.m_OptionManager.add("finder", "finder", (Object)new AllFinder());
        this.m_OptionManager.add("min-overlap-ratio", "minOverlapRatio", (Object)0.0, (Number)0.0, (Number)1.0);
        this.m_OptionManager.add("label-key", "labelKey", (Object)"");
        this.m_OptionManager.add("use-other-object", "useOtherObject", (Object)false);
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name of the storage item to merge with (Report or ReportHandler).";
    }

    public void setFinder(ObjectFinder value) {
        this.m_Finder = value;
        this.reset();
    }

    public ObjectFinder getFinder() {
        return this.m_Finder;
    }

    public String finderTipText() {
        return "The object finder for locating the objects of interest.";
    }

    public void setMinOverlapRatio(double value) {
        if (this.getOptionManager().isValid("minOverlapRatio", (Number)value)) {
            this.m_MinOverlapRatio = value;
            this.reset();
        }
    }

    public double getMinOverlapRatio() {
        return this.m_MinOverlapRatio;
    }

    public String minOverlapRatioTipText() {
        return "The minimum ratio that an overlap must have before being considered an actual overlap.";
    }

    public void setLabelKey(String value) {
        this.m_LabelKey = value;
        this.reset();
    }

    public String getLabelKey() {
        return this.m_LabelKey;
    }

    public String labelKeyTipText() {
        return "The (optional) key for a string label in the meta-data; if supplied the value of the object with the highest overlap gets stored in the report using overlap_label_highest, overlap_label_highest_match stores whether the labels match.";
    }

    public void setUseOtherObject(boolean value) {
        this.m_UseOtherObject = value;
        this.reset();
    }

    public boolean getUseOtherObject() {
        return this.m_UseOtherObject;
    }

    public String useOtherObjectTipText() {
        return "If enabled, the object data from the other report is used/forwarded in case of an overlap.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"storageName", (Object)this.m_StorageName, (String)"storage: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"finder", (Object)this.m_Finder, (String)", finder: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"minOverlapRatio", (Object)this.m_MinOverlapRatio, (String)", overlap ratio: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"labelKey", (Object)(this.m_LabelKey.isEmpty() ? "-none-" : this.m_LabelKey), (String)", label key: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"useOtherObject", (boolean)this.m_UseOtherObject, (String)"use other obj", (String)", ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{AbstractImageContainer.class, Report.class, ReportHandler.class};
    }

    public Class[] generates() {
        return new Class[]{AbstractImageContainer.class, Report.class, ReportHandler.class};
    }

    protected String doExecute() {
        String result = null;
        Object output = null;
        Report thisReport = null;
        Report otherReport = null;
        if (this.m_InputToken.getPayload() instanceof AbstractImageContainer) {
            thisReport = ((AbstractImageContainer)this.m_InputToken.getPayload()).getReport();
        } else if (this.m_InputToken.getPayload() instanceof Report) {
            thisReport = (Report)this.m_InputToken.getPayload();
        } else if (this.m_InputToken.getPayload() instanceof ReportHandler) {
            thisReport = ((ReportHandler)this.m_InputToken.getPayload()).getReport();
        } else {
            result = "Unsupported input class: " + Utils.classToString((Object)this.m_InputToken.getPayload());
        }
        if (thisReport != null) {
            Object obj = this.getStorageHandler().getStorage().get(this.m_StorageName);
            if (obj == null) {
                result = "Failed to retrieve storage item: " + this.m_StorageName;
            } else if (obj instanceof Report) {
                otherReport = (Report)obj;
            } else if (obj instanceof ReportHandler) {
                otherReport = ((ReportHandler)obj).getReport();
            } else {
                result = "Unhandled type of storage item '" + this.m_StorageName + "': " + Utils.classToString((Object)obj);
            }
        }
        if (otherReport != null) {
            LocatedObjects thisObjs = this.m_Finder.findObjects(LocatedObjects.fromReport(thisReport, this.m_Finder.getPrefix()));
            LocatedObjects otherObjs = this.m_Finder.findObjects(LocatedObjects.fromReport(otherReport, this.m_Finder.getPrefix()));
            LocatedObjects newObjs = new LocatedObjects();
            if (thisObjs.size() == 0) {
                newObjs = otherObjs;
            } else {
                for (LocatedObject thisObj : thisObjs) {
                    int count = 0;
                    double overlapHighest = 0.0;
                    String labelHighest = UNKNOWN_LABEL;
                    String thisLabel = UNKNOWN_LABEL;
                    if (!this.m_LabelKey.isEmpty() && thisObj.getMetaData().containsKey(this.m_LabelKey)) {
                        thisLabel = "" + thisObj.getMetaData().get(this.m_LabelKey);
                    }
                    LocatedObject actObj = thisObj;
                    for (LocatedObject otherObj : otherObjs) {
                        double ratio = thisObj.overlapRatio(otherObj);
                        if (!(ratio >= this.m_MinOverlapRatio)) continue;
                        ++count;
                        if (!(ratio > overlapHighest)) continue;
                        if (this.m_UseOtherObject) {
                            actObj = otherObj;
                        }
                        overlapHighest = ratio;
                        if (this.m_LabelKey.isEmpty()) continue;
                        if (otherObj.getMetaData().containsKey(this.m_LabelKey)) {
                            labelHighest = "" + otherObj.getMetaData().get(this.m_LabelKey);
                            continue;
                        }
                        labelHighest = UNKNOWN_LABEL;
                    }
                    actObj = actObj.getClone();
                    actObj.getMetaData().put(OVERLAP_COUNT, count);
                    actObj.getMetaData().put(OVERLAP_PERCENTAGE_HIGHEST, overlapHighest);
                    if (!this.m_LabelKey.isEmpty()) {
                        actObj.getMetaData().put(OVERLAP_LABEL_HIGHEST, labelHighest);
                        actObj.getMetaData().put(OVERLAP_LABEL_HIGHEST_MATCH, thisLabel.equals(labelHighest));
                    }
                    newObjs.add(actObj);
                }
            }
            try {
                Report newReport = (Report)thisReport.getClass().newInstance();
                for (AbstractField field : thisReport.getFields()) {
                    if (field.getName().startsWith(this.m_Finder.getPrefix())) continue;
                    newReport.addField(field);
                    newReport.setValue(field, thisReport.getValue(field));
                }
                newReport.mergeWith(newObjs.toReport(this.m_Finder.getPrefix()));
                if (this.m_InputToken.getPayload() instanceof AbstractImageContainer) {
                    output = this.m_InputToken.getPayload();
                    ((AbstractImageContainer)output).setReport(newReport);
                } else if (this.m_InputToken.getPayload() instanceof MutableReportHandler) {
                    output = this.m_InputToken.getPayload();
                    ((MutableReportHandler)output).setReport(newReport);
                } else {
                    output = newReport;
                }
            }
            catch (Exception e) {
                result = this.handleException("Failed to create new report with updated objects!", e);
                output = null;
            }
        }
        if (output != null) {
            this.m_OutputToken = new Token(output);
        }
        return result;
    }
}

