/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.data.Notes;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.imagepreparation.AbstractImagePreparation;
import adams.flow.transformer.imagepreparation.PassThrough;
import java.awt.image.BufferedImage;

public class ImagePreparation
extends AbstractTransformer {
    private static final long serialVersionUID = 6036066299048043436L;
    protected AbstractImagePreparation m_Preparation;

    public String globalInfo() {
        return "Preprocesses an image.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("preparation", "preparation", (Object)new PassThrough());
    }

    public void setPreparation(AbstractImagePreparation value) {
        this.m_Preparation = value;
        this.reset();
    }

    public AbstractImagePreparation getPreparation() {
        return this.m_Preparation;
    }

    public String preparationTipText() {
        return "The algorithm for preprocessing the image.";
    }

    public String getQuickInfo() {
        String result = "preparation: ";
        String variable = this.getOptionManager().getVariableForProperty("preparation");
        result = variable != null ? result + variable : result + ((Object)((Object)this.m_Preparation)).getClass().getSimpleName();
        return result;
    }

    public Class[] accepts() {
        return new Class[]{AbstractImageContainer.class, BufferedImage.class};
    }

    public Class[] generates() {
        return new Class[]{AbstractImageContainer.class};
    }

    protected String doExecute() {
        Notes notes;
        BufferedImage image;
        String result = null;
        if (this.m_InputToken.getPayload() instanceof AbstractImageContainer) {
            image = ((AbstractImageContainer)this.m_InputToken.getPayload()).toBufferedImage();
            notes = ((AbstractImageContainer)this.m_InputToken.getPayload()).getNotes();
        } else {
            image = (BufferedImage)this.m_InputToken.getPayload();
            notes = null;
        }
        if (this.isHeadless()) {
            BufferedImageContainer cont = new BufferedImageContainer();
            cont.setImage((Object)image);
            if (notes != null) {
                cont.setNotes(notes);
            }
            this.m_OutputToken = new Token((Object)cont);
            return result;
        }
        try {
            BufferedImage processed = this.m_Preparation.process(image);
            BufferedImageContainer cont = new BufferedImageContainer();
            if (notes != null) {
                cont.getNotes().mergeWith(notes);
            }
            if (this.m_Preparation.hasErrors()) {
                for (String error : this.m_Preparation.getErrors()) {
                    cont.getNotes().addError(((Object)((Object)this)).getClass(), error);
                }
            }
            if (this.m_Preparation.hasWarnings()) {
                for (String warning : this.m_Preparation.getWarnings()) {
                    cont.getNotes().addWarning(((Object)((Object)this)).getClass(), warning);
                }
            }
            cont.setImage((Object)processed);
            this.m_OutputToken = new Token((Object)cont);
        }
        catch (Exception e) {
            result = this.handleException("Failed to preprocess image!", e);
        }
        return result;
    }

    public void stopExecution() {
        this.m_Preparation.stopExecution();
        super.stopExecution();
    }
}

