/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.data.image.AbstractImageContainer;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.provenance.ActorType;
import adams.flow.provenance.Provenance;
import adams.flow.provenance.ProvenanceContainer;
import adams.flow.provenance.ProvenanceInformation;
import adams.flow.transformer.AbstractInteractiveTransformerDialog;
import adams.flow.transformer.pixelselector.AbstractPixelSelectorAction;
import adams.flow.transformer.pixelselector.AbstractPixelSelectorOverlay;
import adams.flow.transformer.pixelselector.PixelSelectorPanel;
import adams.gui.core.BasePanel;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class PixelSelector
extends AbstractInteractiveTransformerDialog {
    private static final long serialVersionUID = 2400845362270344769L;
    protected AbstractPixelSelectorAction[] m_Actions;
    protected AbstractPixelSelectorOverlay[] m_Overlays;
    protected int m_SplitterPosition;
    protected Boolean m_Approved;

    public String globalInfo() {
        return "Allows the user to select pixels. How the pixels are interpreted depends on the actions selected.\nIn addition, overlays that visualize the information stored in the image's report can be selected as well. The overlays offer information on what actions generate the data that is required for proper visualization.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("action", "actions", (Object)new AbstractPixelSelectorAction[0]);
        this.m_OptionManager.add("overlay", "overlays", (Object)new AbstractPixelSelectorOverlay[0]);
        this.m_OptionManager.add("splitter-pos", "splitterPosition", (Object)this.getDefaultSplitterPosition(), (Number)1, null);
    }

    public void setActions(AbstractPixelSelectorAction[] value) {
        this.m_Actions = value;
        this.reset();
    }

    public AbstractPixelSelectorAction[] getActions() {
        return this.m_Actions;
    }

    public String actionsTipText() {
        return "The overlays available to the user from the popup menu of the viewer.";
    }

    public void setOverlays(AbstractPixelSelectorOverlay[] value) {
        this.m_Overlays = value;
        this.reset();
    }

    public AbstractPixelSelectorOverlay[] getOverlays() {
        return this.m_Overlays;
    }

    public String overlaysTipText() {
        return "The image overlays to use in the viewer.";
    }

    protected int getDefaultSplitterPosition() {
        return 500;
    }

    public void setSplitterPosition(int value) {
        this.m_SplitterPosition = value;
        this.reset();
    }

    public int getSplitterPosition() {
        return this.m_SplitterPosition;
    }

    public String splitterPositionTipText() {
        return "The initial position of the splitter in the viewer panel.";
    }

    public Class[] accepts() {
        return new Class[]{AbstractImageContainer.class};
    }

    public Class[] generates() {
        return new Class[]{AbstractImageContainer.class};
    }

    public void clearPanel() {
        ((PixelSelectorPanel)this.m_Panel).setImage(null);
    }

    protected BasePanel newPanel() {
        PixelSelectorPanel result = new PixelSelectorPanel();
        result.setSplitterPosition(this.m_SplitterPosition);
        result.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PixelSelector.this.m_Approved = ((PixelSelectorPanel)PixelSelector.this.m_Panel).getResult() == 1;
            }
        });
        return result;
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            for (int i = 0; i < this.m_Actions.length; ++i) {
                String msg = this.m_Actions[i].check();
                if (msg == null) continue;
                result = "Action #" + (i + 1) + " (" + ((Object)((Object)this.m_Actions[i])).getClass().getName() + ") failed check: " + msg;
                break;
            }
        }
        return result;
    }

    public boolean doInteract() {
        boolean result = false;
        PixelSelectorPanel panel = (PixelSelectorPanel)this.m_Panel;
        panel.setImage((AbstractImageContainer)this.m_InputToken.getPayload());
        panel.setActions(this.m_Actions);
        panel.clearImageOverlays();
        for (AbstractPixelSelectorOverlay overlay : this.m_Overlays) {
            panel.addImageOverlay(overlay);
        }
        this.registerWindow((Window)this.m_Dialog, this.m_Dialog.getTitle());
        this.m_Dialog.setVisible(true);
        this.deregisterWindow((Window)this.m_Dialog);
        if (this.m_Approved != null && this.m_Approved.booleanValue()) {
            result = true;
            this.m_OutputToken = new Token((Object)panel.getImage());
        }
        return result;
    }

    protected String doExecute() {
        this.m_Approved = null;
        String result = super.doExecute();
        if (this.m_Approved == null) {
            result = this.m_StopMessage != null && this.m_StopMessage.length() > 0 ? this.m_StopMessage : "User cancelled dialog!";
        }
        if (result == null && this.m_OutputToken != null) {
            this.updateProvenance((ProvenanceContainer)this.m_OutputToken);
        }
        return result;
    }

    public void updateProvenance(ProvenanceContainer cont) {
        if (Provenance.getSingleton().isEnabled()) {
            if (this.m_InputToken.hasProvenance()) {
                cont.setProvenance(this.m_InputToken.getProvenance().getClone());
            }
            cont.addProvenance(new ProvenanceInformation(ActorType.PREPROCESSOR, this.m_InputToken.getPayload().getClass(), (Actor)this, this.m_OutputToken.getPayload().getClass()));
        }
    }
}

