/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.locateobjects;

import adams.core.CloneHandler;
import adams.core.Utils;
import adams.core.base.QuadrilateralLocation;
import adams.data.image.BufferedImageHelper;
import adams.data.statistics.StatUtils;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class LocatedObject
implements Serializable,
CloneHandler<LocatedObject> {
    private static final long serialVersionUID = 8662599273386642371L;
    public static final String KEY_POLY_X = "poly_x";
    public static final String KEY_POLY_Y = "poly_y";
    protected BufferedImage m_Image;
    protected int m_X;
    protected int m_Y;
    protected int m_Width;
    protected int m_Height;
    protected Rectangle m_ActualRectangle;
    protected Polygon m_ActualPolygon;
    protected Map<String, Object> m_MetaData;

    public LocatedObject(BufferedImage image, int x, int y, int width, int height) {
        this(image, x, y, width, height, null);
    }

    public LocatedObject(BufferedImage image, int x, int y, int width, int height, Map<String, Object> metaData) {
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        this.m_Image = image;
        this.m_X = x;
        this.m_Y = y;
        this.m_Width = width;
        this.m_Height = height;
        this.m_MetaData = metaData == null ? new HashMap() : metaData;
        this.m_ActualRectangle = null;
        this.m_ActualPolygon = null;
    }

    public LocatedObject getClone() {
        return new LocatedObject(this.m_Image != null ? BufferedImageHelper.deepCopy((BufferedImage)this.m_Image) : null, this.m_X, this.m_Y, this.m_Width, this.m_Height, this.getMetaData(true));
    }

    public BufferedImage getImage() {
        return this.m_Image;
    }

    public int getX() {
        return this.m_X;
    }

    public int getY() {
        return this.m_Y;
    }

    public int getWidth() {
        return this.m_Width;
    }

    public int getHeight() {
        return this.m_Height;
    }

    public String getIndexString() {
        String result = null;
        if (this.getMetaData() != null && this.getMetaData().containsKey("index")) {
            result = "" + this.getMetaData().get("index");
        }
        return result;
    }

    public int getIndex() {
        int result = -1;
        String index = this.getIndexString();
        if (index != null) {
            try {
                result = Integer.parseInt(index);
            }
            catch (Exception e) {
                result = -1;
            }
        }
        return result;
    }

    public Map<String, Object> getMetaData() {
        return this.getMetaData(false);
    }

    public Map<String, Object> getMetaData(boolean copy) {
        if (!copy) {
            return this.m_MetaData;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.putAll(this.m_MetaData);
        return result;
    }

    public Rectangle getActualRectangle() {
        if (this.m_ActualRectangle == null) {
            this.m_ActualRectangle = this.getRectangle();
        }
        return this.m_ActualRectangle;
    }

    public Polygon getActualPolygon() {
        if (this.m_ActualPolygon == null) {
            this.m_ActualPolygon = this.getPolygon();
        }
        return this.m_ActualPolygon;
    }

    public void scale(double scale) {
        this.m_ActualRectangle = this.getRectangle(scale);
        this.m_ActualPolygon = this.getPolygon(scale);
    }

    public QuadrilateralLocation getLocation() {
        return new QuadrilateralLocation(this.m_X, this.m_Y, this.m_X + this.m_Width - 1, this.m_Y, this.m_X + this.m_Width - 1, this.m_Y + this.m_Height - 1, this.m_X, this.m_Y + this.m_Height - 1);
    }

    public boolean hasPolygon() {
        return this.m_MetaData.containsKey(KEY_POLY_X) && this.m_MetaData.containsKey(KEY_POLY_Y);
    }

    public Rectangle getRectangle() {
        return this.getRectangle(1.0);
    }

    public Rectangle getRectangle(double scale) {
        return new Rectangle((int)((double)this.getX() * scale), (int)((double)this.getY() * scale), (int)((double)this.getWidth() * scale), (int)((double)this.getHeight() * scale));
    }

    protected int[] getPolyCoords(String key) {
        int[] result;
        if (!this.hasPolygon()) {
            result = new int[]{};
        } else {
            String[] parts = this.m_MetaData.get(key).toString().split(",");
            result = new int[parts.length];
            try {
                for (int i = 0; i < parts.length; ++i) {
                    result[i] = (int)Double.parseDouble(parts[i]);
                }
            }
            catch (Exception e) {
                result = new int[]{};
            }
        }
        return result;
    }

    public int[] getPolygonX() {
        return this.getPolyCoords(KEY_POLY_X);
    }

    public int[] getPolygonY() {
        return this.getPolyCoords(KEY_POLY_Y);
    }

    public Polygon getPolygon() {
        return this.getPolygon(1.0);
    }

    public Polygon getPolygon(double scale) {
        int[] x = this.getPolygonX();
        int[] y = this.getPolygonY();
        if (x.length == 0 || x.length != y.length) {
            return null;
        }
        if (scale != 1.0) {
            for (int i = 0; i < x.length; ++i) {
                x[i] = (int)((double)x[i] * scale);
                y[i] = (int)((double)y[i] * scale);
            }
        }
        return new Polygon(x, y, x.length);
    }

    public void setPolygon(Polygon value) {
        this.getMetaData().put(KEY_POLY_X, Utils.flatten((Object[])StatUtils.toNumberArray((int[])value.xpoints), (String)","));
        this.getMetaData().put(KEY_POLY_Y, Utils.flatten((Object[])StatUtils.toNumberArray((int[])value.ypoints), (String)","));
    }

    public boolean makeFit(int width, int height) {
        boolean result = false;
        if (this.m_X < 0) {
            this.m_Width += this.m_X;
            this.m_X = 0;
            result = true;
        }
        if (this.m_X + this.m_Width > width) {
            this.m_Width -= this.m_X + this.m_Width - width;
            result = true;
        }
        if (this.m_Y < 0) {
            this.m_Height += this.m_Y;
            this.m_Y = 0;
            result = true;
        }
        if (this.m_Y + this.m_Height > height) {
            this.m_Height -= this.m_Y + this.m_Height - height;
            result = true;
        }
        if (this.hasPolygon()) {
            int[] px = this.getPolygonX();
            int[] py = this.getPolygonY();
            boolean padjusted = false;
            for (int i = 0; i < px.length; ++i) {
                if (px[i] < 0) {
                    px[i] = 0;
                    padjusted = true;
                }
                if (px[i] >= width) {
                    px[i] = width - 1;
                    padjusted = true;
                }
                if (py[i] < 0) {
                    py[i] = 0;
                    padjusted = true;
                }
                if (py[i] < height) continue;
                py[i] = height - 1;
                padjusted = true;
            }
            if (padjusted) {
                this.setPolygon(new Polygon(px, py, px.length));
                result = true;
            }
        }
        return result;
    }

    protected boolean inRange(int value, int min, int max) {
        return value >= min && value <= max;
    }

    public boolean overlap(LocatedObject other) {
        int thisLeft = this.getX();
        int thisRight = this.getX() + this.getWidth() - 1;
        int thisTop = this.getY();
        int thisBottom = this.getY() + this.getHeight() - 1;
        int otherLeft = other.getX();
        int otherRight = other.getX() + other.getWidth() - 1;
        int otherTop = other.getY();
        int otherBottom = other.getY() + other.getHeight() - 1;
        boolean xOverlap = this.inRange(thisLeft, otherLeft, otherRight) || this.inRange(otherLeft, thisLeft, thisRight);
        boolean yOverlap = this.inRange(thisTop, otherTop, otherBottom) || this.inRange(otherTop, thisTop, thisBottom);
        return xOverlap && yOverlap;
    }

    public Rectangle overlapRectangle(LocatedObject other) {
        if (!this.overlap(other)) {
            return null;
        }
        return this.getRectangle().intersection(other.getRectangle());
    }

    public double overlapRatio(LocatedObject other) {
        Rectangle overlap = this.overlapRectangle(other);
        if (overlap == null) {
            return 0.0;
        }
        return overlap.getWidth() * overlap.getHeight() / (double)(this.getWidth() * this.getHeight());
    }

    public String toString() {
        if (this.m_Image != null) {
            return "@" + this.m_Image.hashCode() + ", x=" + this.m_X + ", y=" + this.m_Y + ", w=" + this.m_Width + ", h=" + this.m_Height;
        }
        return "x=" + this.m_X + ", y=" + this.m_Y + ", w=" + this.m_Width + ", h=" + this.m_Height;
    }
}

