/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.negativeregions;

import adams.data.image.AbstractImageContainer;
import adams.flow.transformer.locateobjects.LocatedObject;
import adams.flow.transformer.locateobjects.LocatedObjects;
import adams.flow.transformer.negativeregions.AbstractMetaNegativeRegionsGenerator;

public class MinDimensions
extends AbstractMetaNegativeRegionsGenerator {
    private static final long serialVersionUID = -904202231629949668L;
    protected int m_MinWidth;
    protected int m_MinHeight;

    public String globalInfo() {
        return "Enforces the specified minimum dimensions.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("min-width", "minWidth", (Object)-1, (Number)-1, null);
        this.m_OptionManager.add("min-height", "minHeight", (Object)-1, (Number)-1, null);
    }

    public void setMinWidth(int value) {
        if (this.getOptionManager().isValid("minWidth", (Number)value)) {
            this.m_MinWidth = value;
            this.reset();
        }
    }

    public int getMinWidth() {
        return this.m_MinWidth;
    }

    public String minWidthTipText() {
        return "The minimum width that a negative region must have, ignored if <1.";
    }

    public void setMinHeight(int value) {
        if (this.getOptionManager().isValid("minHeight", (Number)value)) {
            this.m_MinHeight = value;
            this.reset();
        }
    }

    public int getMinHeight() {
        return this.m_MinHeight;
    }

    public String minHeightTipText() {
        return "The minimum height that a negative region must have, ignored if <1.";
    }

    @Override
    protected LocatedObjects doGenerateRegions(AbstractImageContainer cont) {
        LocatedObjects result = this.getActualAlgorithm().generateRegions(cont);
        if (result != null && (this.m_MinHeight > 0 || this.m_MinWidth > 0)) {
            int i = 0;
            while (i < result.size()) {
                if (this.m_MinWidth > 0 && ((LocatedObject)result.get(i)).getWidth() < this.m_MinWidth) {
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("Removed, width too small: " + result.remove(i));
                    }
                    result.remove(i);
                    continue;
                }
                if (this.m_MinHeight > 0 && ((LocatedObject)result.get(i)).getHeight() < this.m_MinHeight) {
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("Removed, height too small: " + result.remove(i));
                    }
                    result.remove(i);
                    continue;
                }
                ++i;
            }
        }
        return result;
    }
}

