/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.data.io.input.AbstractImageReader;
import adams.gui.core.GUIHelper;
import adams.gui.core.MultiPagePane;
import adams.gui.tools.ImageProcessorPanel;
import adams.gui.tools.ImageProcessorSubPanel;
import java.awt.Component;
import java.io.File;

public class ImageProcessorMultiPagePane
extends MultiPagePane {
    private static final long serialVersionUID = 4949565559707097445L;
    protected ImageProcessorPanel m_Owner;

    public ImageProcessorMultiPagePane(ImageProcessorPanel owner) {
        this.m_Owner = owner;
        this.setMaxPageCloseUndo(10);
        this.setDividerLocation(250);
    }

    public ImageProcessorPanel getOwner() {
        return this.m_Owner;
    }

    public ImageProcessorSubPanel getCurrentPanel() {
        return this.getPanelAt(this.getSelectedIndex());
    }

    public ImageProcessorSubPanel getPanelAt(int index) {
        if (index < 0 || index >= this.getPageCount()) {
            return null;
        }
        return (ImageProcessorSubPanel)((Object)this.getPageAt(index));
    }

    public ImageProcessorSubPanel[] getAllPanels() {
        ImageProcessorSubPanel[] result = new ImageProcessorSubPanel[this.getPageCount()];
        for (int i = 0; i < this.getPageCount(); ++i) {
            result[i] = (ImageProcessorSubPanel)((Object)this.getPageAt(i));
        }
        return result;
    }

    public File getCurrentFile() {
        return this.getFileAt(this.getSelectedIndex());
    }

    public File getFileAt(int index) {
        File result = null;
        ImageProcessorSubPanel panel = this.getPanelAt(index);
        if (panel != null) {
            result = panel.getCurrentFile();
        }
        return result;
    }

    public boolean load(File file) {
        return this.load(file, null);
    }

    public boolean load(File file, AbstractImageReader reader) {
        ImageProcessorSubPanel panel = new ImageProcessorSubPanel(this);
        if (!panel.load(file, reader)) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to open image '" + file + "'!"));
            return false;
        }
        this.addPage(file.getName(), (Component)((Object)panel));
        this.setSelectedPage((Component)((Object)panel));
        return true;
    }
}

