/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.core.Utils;
import adams.core.base.BaseRegExp;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.data.io.input.AbstractImageReader;
import adams.data.io.input.DefaultSimpleReportReader;
import adams.data.io.input.JAIImageReader;
import adams.data.report.Report;
import adams.gui.core.ColorHelper;
import adams.gui.core.Fonts;
import adams.gui.tools.previewbrowser.AbstractContentHandler;
import adams.gui.tools.previewbrowser.PreviewPanel;
import adams.gui.visualization.image.ImageOverlay;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.image.MultiImageOverlay;
import adams.gui.visualization.image.ObjectLocationsOverlayFromReport;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;

public class AnnotationsAndPredictionsFromReport
extends AbstractContentHandler {
    private static final long serialVersionUID = -3962259305718630395L;
    public static final String PREFIX_ANNOTATIONS = "Object.";
    public static final String PREFIX_PREDICTIONS = "Prediction.";
    public static final Color COLOR_ANNOTATIONS = Color.RED;
    public static final Color COLOR_PREDICTIONS = Color.GREEN;
    protected String m_Prefix;
    protected String m_TypeSuffix;
    protected BaseRegExp m_TypeRegExp;
    protected String m_LabelFormat;
    protected Font m_LabelFont;

    public String globalInfo() {
        return "Displays the following image types with an overlay for the annotations and predictions stored in the report with the same name: " + Utils.arrayToString((Object)this.getExtensions()) + "\nAnnotations have to have the prefix '" + PREFIX_ANNOTATIONS + "' and predictions '" + PREFIX_PREDICTIONS + "'.\nThe color for annotations is " + this.toString(COLOR_ANNOTATIONS) + " and for predictions " + this.toString(COLOR_PREDICTIONS) + ".";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("prefix", "prefix", (Object)PREFIX_ANNOTATIONS);
        this.m_OptionManager.add("type-suffix", "typeSuffix", (Object)".type");
        this.m_OptionManager.add("type-regexp", "typeRegExp", (Object)new BaseRegExp(".*"));
        this.m_OptionManager.add("label-format", "labelFormat", (Object)"#. $");
        this.m_OptionManager.add("label-font", "labelFont", (Object)Fonts.getSansFont((int)14));
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The prefix of fields in the report to identify as object location, eg 'Object.'.";
    }

    public void setTypeSuffix(String value) {
        this.m_TypeSuffix = value;
        this.reset();
    }

    public String getTypeSuffix() {
        return this.m_TypeSuffix;
    }

    public String typeSuffixTipText() {
        return "The suffix of fields in the report to identify the type.";
    }

    public void setTypeRegExp(BaseRegExp value) {
        this.m_TypeRegExp = value;
        this.reset();
    }

    public BaseRegExp getTypeRegExp() {
        return this.m_TypeRegExp;
    }

    public String typeRegExpTipText() {
        return "The regular expression that the types must match in order to get drawn (eg only plotting a subset).";
    }

    public void setLabelFormat(String value) {
        this.m_LabelFormat = value;
        this.reset();
    }

    public String getLabelFormat() {
        return this.m_LabelFormat;
    }

    public String labelFormatTipText() {
        return "The label format string to use for the rectangles; '#' for index, '@' for type and '$' for short type (type suffix must be defined for '@' and '$'); for instance: '# @'.";
    }

    public void setLabelFont(Font value) {
        this.m_LabelFont = value;
        this.reset();
    }

    public Font getLabelFont() {
        return this.m_LabelFont;
    }

    public String labelFontTipText() {
        return "The font to use for the labels.";
    }

    protected String toString(Color color) {
        if (ColorHelper.toName((Color)color) == null) {
            return ColorHelper.toHex((Color)color);
        }
        return ColorHelper.toName((Color)color);
    }

    public String[] getExtensions() {
        return new JAIImageReader().getFormatExtensions();
    }

    protected PreviewPanel createPreview(File file) {
        ImagePanel panel = new ImagePanel();
        MultiImageOverlay multi = null;
        Report report = null;
        File reportFile = FileUtils.replaceExtension((File)file, (String)".report");
        if (reportFile.exists() && reportFile.isFile()) {
            DefaultSimpleReportReader reportReader = new DefaultSimpleReportReader();
            reportReader.setInput(new PlaceholderFile(reportFile));
            List reports = reportReader.read();
            if (reports.size() > 0) {
                report = (Report)reports.get(0);
                ObjectLocationsOverlayFromReport annotations = new ObjectLocationsOverlayFromReport();
                annotations.setPrefix(this.m_Prefix);
                annotations.setTypeSuffix(this.m_TypeSuffix);
                annotations.setTypeRegExp((BaseRegExp)this.m_TypeRegExp.getClone());
                annotations.setLabelFormat(this.m_LabelFormat);
                annotations.setLabelFont(this.m_LabelFont);
                annotations.setPrefix(PREFIX_ANNOTATIONS);
                annotations.setColor(COLOR_ANNOTATIONS);
                ObjectLocationsOverlayFromReport predictions = new ObjectLocationsOverlayFromReport();
                predictions.setPrefix(this.m_Prefix);
                predictions.setTypeSuffix(this.m_TypeSuffix);
                predictions.setTypeRegExp((BaseRegExp)this.m_TypeRegExp.getClone());
                predictions.setLabelFormat(this.m_LabelFormat);
                predictions.setLabelFont(this.m_LabelFont);
                predictions.setPrefix(PREFIX_PREDICTIONS);
                predictions.setColor(COLOR_PREDICTIONS);
                multi = new MultiImageOverlay();
                multi.setOverlays(new ImageOverlay[]{annotations, predictions});
            }
        }
        if (multi != null) {
            panel.addImageOverlay(multi);
            panel.setAdditionalProperties(report);
        }
        panel.load(file, (AbstractImageReader)new JAIImageReader(), -1.0);
        return new PreviewPanel((JComponent)panel, (JComponent)panel.getPaintPanel());
    }
}

