/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.image;

import adams.gui.visualization.image.AbstractObjectOverlayFromReport;
import adams.gui.visualization.image.ImagePanel;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.List;

public class ObjectLocationsOverlayFromReport
extends AbstractObjectOverlayFromReport {
    private static final long serialVersionUID = 6356419097401574024L;
    protected boolean m_Filled;
    protected boolean m_PolygonBounds;

    public String globalInfo() {
        return "Displays the locations of objects in the image, using data from the attached report.\nSuffixes:\n.x\n.y\n.width\n.height\nOptionally, if type information is available per object, the locations can be displayed in distinct colors per type. The type itself can be displayed as well.\nIf polygon data should be available (.poly_x and .poly_y), then this takes precedence over the rectangle coordinates.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("filled", "filled", (Object)false);
        this.m_OptionManager.add("polygon-bounds", "polygonBounds", (Object)false);
    }

    public void setFilled(boolean value) {
        this.m_Filled = value;
        this.reset();
    }

    public boolean getFilled() {
        return this.m_Filled;
    }

    public String filledTipText() {
        return "If enabled, the shape is drawn filled.";
    }

    public void setPolygonBounds(boolean value) {
        this.m_PolygonBounds = value;
        this.reset();
    }

    public boolean getPolygonBounds() {
        return this.m_PolygonBounds;
    }

    public String polygonBoundsTipText() {
        return "If enabled, the polygon bounds are drawn as well.";
    }

    @Override
    protected void doPaintObjects(ImagePanel.PaintPanel panel, Graphics g, List<Polygon> locations) {
        g.setColor(this.getColor());
        g.setFont(this.getLabelFont());
        for (Polygon poly : locations) {
            String label;
            if (this.getUseColorsPerType() && this.m_Overlays.hasColor(poly)) {
                g.setColor(this.m_Overlays.getColor(poly));
            }
            if (this.m_Filled) {
                g.fillPolygon(poly);
            } else {
                g.drawPolygon(poly);
            }
            Rectangle rect = null;
            if (this.m_PolygonBounds) {
                rect = poly.getBounds();
                g.drawRect(rect.x, rect.y, rect.width, rect.height);
            }
            if (!this.m_Overlays.hasLabel(poly) || (label = this.m_Overlays.getLabel(poly)) == null) continue;
            if (rect == null) {
                rect = poly.getBounds();
            }
            g.drawString(label, (int)(rect.getX() + rect.getWidth() + (double)this.getLabelOffsetX()), (int)(rect.getY() + (double)this.getLabelOffsetY()));
        }
    }
}

